/// <reference path="./internal_*.d.ts" />
declare namespace dev.lambdaurora.spruceui {
    class Position implements Internal.SprucePositioned {
        static of(x: number, y: number): dev.lambdaurora.spruceui.Position;
        getX(): number;
        setAnchor(anchor: Internal.SprucePositioned_): void;
        setRelativeX(x: number): void;
        getY(): number;
        setRelativeY(y: number): void;
        getAnchor(): Internal.SprucePositioned;
        move(x: number, y: number): this;
        static center(parent: Internal.SpruceWidget_, y: number): dev.lambdaurora.spruceui.Position;
        getRelativeX(): number;
        getRelativeY(): number;
        copy(): this;
        static origin(): dev.lambdaurora.spruceui.Position;
        static center(width: number, y: number): dev.lambdaurora.spruceui.Position;
        static of(anchor: Internal.SprucePositioned_, x: number, y: number): dev.lambdaurora.spruceui.Position;
        static center(anchor: Internal.SprucePositioned_, width: number, y: number): dev.lambdaurora.spruceui.Position;
        get x(): number
        set anchor(anchor: Internal.SprucePositioned_)
        set relativeX(x: number)
        get y(): number
        set relativeY(y: number)
        get anchor(): Internal.SprucePositioned
        get relativeX(): number
        get relativeY(): number
    }
    type Position_ = Position;
}
declare namespace io.github.tropheusj.dripstone_fluid_lib.mixin {
    interface ParticleManagerAccessor {
        abstract callRegisterFactory<T extends Internal.ParticleOptions>(arg0: Internal.ParticleType_<T>, arg1: Internal.ParticleEngine$SpriteParticleRegistration_<T>): void;
        abstract callRegisterBlockLeakFactory<T extends Internal.ParticleOptions>(arg0: Internal.ParticleType_<T>, arg1: Internal.ParticleProvider$Sprite_<T>): void;
    }
    type ParticleManagerAccessor_ = ParticleManagerAccessor;
}
declare namespace Internal {
    class ArgumentSignatures extends Internal.Record {
        constructor($$0: Internal.List_<Internal.ArgumentSignatures$Entry>)
        constructor($$0: Internal.FriendlyByteBuf_)
        write($$0: Internal.FriendlyByteBuf_): void;
        get($$0: string): Internal.MessageSignature;
        static signCommand($$0: Internal.SignableCommand_<any>, $$1: Internal.ArgumentSignatures$Signer_): Internal.ArgumentSignatures;
        entries(): Internal.List<Internal.ArgumentSignatures$Entry>;
        static readonly EMPTY: Internal.ArgumentSignatures;
    }
    type ArgumentSignatures_ = ArgumentSignatures;
    class FrameEvaluate$Companion {
        constructor($constructor_marker: any_)
    }
    type FrameEvaluate$Companion_ = FrameEvaluate$Companion;
    interface AutoSyncedComponent extends Internal.ComponentPacketWriter, dev.onyxstudios.cca.api.v3.component.Component, Internal.PlayerSyncPredicate {
        applySyncPacket(buf: Internal.FriendlyByteBuf_): void;
        abstract readFromNbt(arg0: Internal.CompoundTag_): void;
        shouldSyncWith(player: Internal.ServerPlayer_): boolean;
        only(player: Internal.Player_): Internal.PlayerSyncPredicate;
        abstract writeToNbt(arg0: Internal.CompoundTag_): void;
        all(): Internal.PlayerSyncPredicate;
        abstract equals(arg0: any): boolean;
        writeSyncPacket(buf: Internal.FriendlyByteBuf_, recipient: Internal.ServerPlayer_): void;
    }
    type AutoSyncedComponent_ = AutoSyncedComponent;
    abstract class StructurePiece {
        constructor($$0: Internal.StructurePieceType_, $$1: Internal.CompoundTag_)
        static findCollisionPiece($$0: Internal.List_<Internal.StructurePiece>, $$1: Internal.BoundingBox_): Internal.StructurePiece;
        abstract postProcess(arg0: Internal.WorldGenLevel_, arg1: Internal.StructureManager_, arg2: Internal.ChunkGenerator_, arg3: Internal.RandomSource_, arg4: Internal.BoundingBox_, arg5: Internal.ChunkPos_, arg6: BlockPos_): void;
        move($$0: number, $$1: number, $$2: number): void;
        setGenDepth($$0: number): void;
        isCloseToChunk($$0: Internal.ChunkPos_, $$1: number): boolean;
        getGenDepth(): number;
        getOrientation(): Internal.Direction;
        setOrientation($$0: Internal.Direction_): void;
        getType(): Internal.StructurePieceType;
        createTag($$0: Internal.StructurePieceSerializationContext_): Internal.CompoundTag;
        getBoundingBox(): Internal.BoundingBox;
        getRotation(): Internal.Rotation;
        getMirror(): Internal.Mirror;
        static createBoundingBox($$0: Internal.Stream_<Internal.StructurePiece>): Internal.BoundingBox;
        static reorient($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.BlockState;
        addChildren($$0: Internal.StructurePiece_, $$1: Internal.StructurePieceAccessor_, $$2: Internal.RandomSource_): void;
        getLocatorPosition(): BlockPos;
        set genDepth($$0: number)
        get genDepth(): number
        get orientation(): Internal.Direction
        set orientation($$0: Internal.Direction_)
        get type(): Internal.StructurePieceType
        get boundingBox(): Internal.BoundingBox
        get rotation(): Internal.Rotation
        get mirror(): Internal.Mirror
        get locatorPosition(): BlockPos
    }
    type StructurePiece_ = StructurePiece;
    interface AttributeSet {
        abstract containsAttributes(arg0: Internal.AttributeSet_): boolean;
        abstract copyAttributes(): this;
        abstract isDefined(arg0: any): boolean;
        abstract getAttributeCount(): number;
        abstract getResolveParent(): this;
        abstract containsAttribute(arg0: any, arg1: any): boolean;
        abstract getAttribute(arg0: any): any;
        abstract isEqual(arg0: Internal.AttributeSet_): boolean;
        abstract getAttributeNames(): Internal.Enumeration<any>;
        get attributeCount(): number
        get resolveParent(): Internal.AttributeSet
        get attributeNames(): Internal.Enumeration<any>
        readonly NameAttribute: Internal.StyleConstants;
        readonly ResolveAttribute: Internal.StyleConstants;
    }
    type AttributeSet_ = AttributeSet;
    class MantleWallSignBlock extends Internal.WallSignBlock {
        constructor(props: Internal.BlockBehaviour$Properties_, type: Internal.WoodType_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MantleWallSignBlock_ = MantleWallSignBlock;
    class MultilevelModifierRecipe$Serializer extends Internal.LoggingRecipeSerializer<Internal.MultilevelModifierRecipe> {
        constructor()
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.MultilevelModifierRecipe;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
    }
    type MultilevelModifierRecipe$Serializer_ = MultilevelModifierRecipe$Serializer;
    abstract class TypeParameter <T> extends Internal.TypeCapture<T> {
    }
    type TypeParameter_<T> = TypeParameter<T>;
    interface DirectoryStream$Filter <T> {
        abstract accept(arg0: T): boolean;
        (arg0: T): boolean;
    }
    type DirectoryStream$Filter_<T> = DirectoryStream$Filter<T>;
    interface TierMixin extends Internal.TierExtensions {
        getTag(): Internal.TagKey<Internal.Block>;
        get tag(): Internal.TagKey<Internal.Block>
    }
    type TierMixin_ = TierMixin;
    abstract class Screen extends Internal.AbstractContainerEventHandler implements net.p3pp3rf1y.sophisticatedcore.mixin.client.accessor.ScreenAccessor, Internal.AccessScreen, net.fabricmc.fabric.mixin.screen.ScreenAccessor, Internal.ScreenInputDelegate, Internal.AccessorScreen, Internal.OwoScreenExtension, io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ScreenAccessor, Internal.Renderable, net.blay09.mods.balm.mixin.ScreenAccessor, Internal.ScreenExtensions, Internal.ScreenAccessor {
        charTyped($$0: string, $$1: number): boolean;
        onFilesDrop($$0: Internal.List_<Internal.Path>): void;
        fabric_getAfterRenderEvent(): net.fabricmc.fabric.api.event.Event<any>;
        narrationEnabled(): void;
        setFocused($$0: boolean): void;
        setTooltipForNextRenderPass($$0: Internal.List_<Internal.FormattedCharSequence>): void;
        renderDirtBackground($$0: Internal.GuiGraphics_): void;
        fabric_getRemoveEvent(): net.fabricmc.fabric.api.event.Event<any>;
        renderWithTooltip($$0: Internal.GuiGraphics_, $$1: number, $$2: number, $$3: number): void;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        mouseClicked($$0: number, $$1: number, $$2: number): boolean;
        static isCut($$0: number): boolean;
        owo$getInstancesView(): Internal.List<any>;
        changeFocus($$0: Internal.ComponentPath_): void;
        fabric_getAfterTickEvent(): net.fabricmc.fabric.api.event.Event<any>;
        addRenderableWidget<T extends Internal.GuiEventListener & Internal.Renderable & Internal.NarratableEntry>($$0: T): T;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        fabric_getBeforeMouseScrollEvent(): net.fabricmc.fabric.api.event.Event<any>;
        fabric_getAllowKeyReleaseEvent(): net.fabricmc.fabric.api.event.Event<any>;
        port_lib$getRenderables(): Internal.List<any>;
        handleComponentClicked($$0: Internal.Style_): boolean;
        static findNarratableWidget($$0: Internal.List_<Internal.NarratableEntry>, $$1: Internal.NarratableEntry_): Internal.Screen$NarratableSearchResult;
        controlling$getRenderables(): Internal.List<any>;
        getTextRenderer(): net.minecraft.client.gui.Font;
        fabric_getBeforeMouseClickEvent(): net.fabricmc.fabric.api.event.Event<any>;
        removed(): void;
        render($$0: Internal.GuiGraphics_, $$1: number, $$2: number, $$3: number): void;
        addRenderableOnly<T extends Internal.Renderable>($$0: T): T;
        static isSelectAll($$0: number): boolean;
        fabric_getAfterMouseClickEvent(): net.fabricmc.fabric.api.event.Event<any>;
        getChildAt($$0: number, $$1: number): Internal.Optional<Internal.GuiEventListener>;
        shouldCloseOnEsc(): boolean;
        isFocused(): boolean;
        libgui$getChildren(): Internal.List<any>;
        fabric_getAfterKeyPressEvent(): net.fabricmc.fabric.api.event.Event<any>;
        balm_getRenderables(): Internal.List<any>;
        getTabOrderGroup(): number;
        getRenderables(): Internal.List<any>;
        callAddRenderableWidget(arg0: Internal.GuiEventListener_): Internal.GuiEventListener;
        init($$0: Internal.Minecraft_, $$1: number, $$2: number): void;
        port_lib$getMinecraft(): Internal.Minecraft;
        getBackgroundMusic(): Internal.Music;
        getNarrationMessage(): net.minecraft.network.chat.Component;
        fabric_getBeforeRenderEvent(): net.fabricmc.fabric.api.event.Event<any>;
        fabric_getAfterMouseReleaseEvent(): net.fabricmc.fabric.api.event.Event<any>;
        static isPaste($$0: number): boolean;
        afterKeyboardAction(): void;
        static hasControlDown(): boolean;
        setInitialFocus($$0: Internal.GuiEventListener_): void;
        getCurrentFocusPath(): Internal.ComponentPath;
        fabric_getAllowKeyPressEvent(): net.fabricmc.fabric.api.event.Event<any>;
        balm_getChildren(): Internal.List<any>;
        owo$updateLayers(): void;
        static wrapScreenError($$0: Internal.Runnable_, $$1: string, $$2: string): void;
        afterMouseAction(): void;
        port_lib$getChildren(): Internal.List<any>;
        redirect$hma000$yet_another_config_lib_v3$modifyFocusCandidates(instance: Internal.ContainerEventHandler_, screenArea: Internal.ScreenRectangle_, direction: Internal.ScreenDirection_, focused: Internal.GuiEventListener_, event: Internal.FocusNavigationEvent_): Internal.List<any>;
        static getTooltipFromItem($$0: Internal.Minecraft_, $$1: Internal.ItemStack_): Internal.List<net.minecraft.network.chat.Component>;
        handler$hok000$create$xaeroPauseScreenOverride(cir: Internal.CallbackInfoReturnable_<any>): void;
        architectury_delegateInputs(): this;
        afterMouseMove(): void;
        static getExtensions(screen: Internal.Screen_): Internal.ScreenExtensions;
        mouseMoved($$0: number, $$1: number): void;
        static isCopy($$0: number): boolean;
        magicalSpecialHackyFocus($$0: Internal.GuiEventListener_): void;
        fabric_getButtons(): Internal.List<any>;
        tick(): void;
        isPauseScreen(): boolean;
        getClient(): Internal.Minecraft;
        getTitle(): net.minecraft.network.chat.Component;
        fabric_getBeforeMouseReleaseEvent(): net.fabricmc.fabric.api.event.Event<any>;
        getNarratables(): Internal.List<any>;
        fabric_getBeforeKeyPressEvent(): net.fabricmc.fabric.api.event.Event<any>;
        fabric_getAfterKeyReleaseEvent(): net.fabricmc.fabric.api.event.Event<any>;
        static hasAltDown(): boolean;
        renderBackground($$0: Internal.GuiGraphics_): void;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        onClose(): void;
        addWidget<T extends Internal.GuiEventListener & Internal.NarratableEntry>($$0: T): T;
        fabric_getAllowMouseReleaseEvent(): net.fabricmc.fabric.api.event.Event<any>;
        static hasShiftDown(): boolean;
        balm_getNarratables(): Internal.List<any>;
        owo$getInstance(layer: Internal.Layer_<any, any>): Internal.Layer$Instance;
        fabric_getAfterMouseScrollEvent(): net.fabricmc.fabric.api.event.Event<any>;
        fabric_getBeforeTickEvent(): net.fabricmc.fabric.api.event.Event<any>;
        mouseDragged($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        resize($$0: Internal.Minecraft_, $$1: number, $$2: number): void;
        mouseReleased($$0: number, $$1: number, $$2: number): boolean;
        setTooltipForNextRenderPass($$0: Internal.List_<Internal.FormattedCharSequence>, $$1: Internal.ClientTooltipPositioner_, $$2: boolean): void;
        fabric_getBeforeKeyReleaseEvent(): net.fabricmc.fabric.api.event.Event<any>;
        getFont(): net.minecraft.client.gui.Font;
        fabric_getAllowMouseScrollEvent(): net.fabricmc.fabric.api.event.Event<any>;
        added(): void;
        handleDelayedNarration(): void;
        triggerImmediateNarration($$0: boolean): void;
        setTooltipForNextRenderPass($$0: Internal.Tooltip_, $$1: Internal.ClientTooltipPositioner_, $$2: boolean): void;
        fabric_getAllowMouseClickEvent(): net.fabricmc.fabric.api.event.Event<any>;
        set focused($$0: boolean)
        set tooltipForNextRenderPass($$0: Internal.List_<Internal.FormattedCharSequence>)
        get textRenderer(): net.minecraft.client.gui.Font
        get focused(): boolean
        get tabOrderGroup(): number
        get renderables(): Internal.List<any>
        get backgroundMusic(): Internal.Music
        get narrationMessage(): net.minecraft.network.chat.Component
        set initialFocus($$0: Internal.GuiEventListener_)
        get currentFocusPath(): Internal.ComponentPath
        get pauseScreen(): boolean
        get client(): Internal.Minecraft
        get title(): net.minecraft.network.chat.Component
        get narratables(): Internal.List<any>
        get font(): net.minecraft.client.gui.Font
        static readonly BACKGROUND_LOCATION: ResourceLocation;
        width: number;
        height: number;
        readonly renderables: Internal.List<Internal.Renderable>;
        readonly narratables: Internal.List<Internal.NarratableEntry>;
    }
    type Screen_ = Screen;
    abstract class Signature extends Internal.SignatureSpi {
        verify(arg0: number[]): boolean;
        sign(): number[];
        static getInstance(arg0: string, arg1: string): Internal.Signature;
        /**
         * @deprecated
        */
        getParameter(arg0: string): any;
        sign(arg0: number[], arg1: number, arg2: number): number;
        initVerify(arg0: Internal.Certificate_): void;
        update(arg0: Internal.ByteBuffer_): void;
        getParameters(): Internal.AlgorithmParameters;
        getProvider(): Internal.Provider;
        setParameter(arg0: Internal.AlgorithmParameterSpec_): void;
        /**
         * @deprecated
        */
        setParameter(arg0: string, arg1: any): void;
        static getInstance(arg0: string): Internal.Signature;
        getAlgorithm(): string;
        verify(arg0: number[], arg1: number, arg2: number): boolean;
        initSign(arg0: Internal.PrivateKey_, arg1: Internal.SecureRandom_): void;
        initSign(arg0: Internal.PrivateKey_): void;
        update(arg0: number[], arg1: number, arg2: number): void;
        update(arg0: number): void;
        static getInstance(arg0: string, arg1: Internal.Provider_): Internal.Signature;
        update(arg0: number[]): void;
        initVerify(arg0: Internal.PublicKey_): void;
        get parameters(): Internal.AlgorithmParameters
        get provider(): Internal.Provider
        set parameter(arg0: Internal.AlgorithmParameterSpec_)
        get algorithm(): string
    }
    type Signature_ = Signature;
    class ForgeConfigSpec$Range <V extends Internal.Comparable<any>> implements Internal.Predicate<any> {
        getMin(): V;
        getClazz(): V;
        test(t: any): boolean;
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        correct(value: any, def: any): any;
        negate(): Internal.Predicate<any>;
        or(arg0: Internal.Predicate_<any>): Internal.Predicate<any>;
        getMax(): V;
        and(arg0: Internal.Predicate_<any>): Internal.Predicate<any>;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
        get min(): V
        get clazz(): V
        get max(): V
    }
    type ForgeConfigSpec$Range_<V extends Internal.Comparable<any>> = ForgeConfigSpec$Range<V>;
    interface RecvByteBufAllocator {
        abstract newHandle(): Internal.RecvByteBufAllocator$Handle;
        (): Internal.RecvByteBufAllocator$Handle_;
    }
    type RecvByteBufAllocator_ = RecvByteBufAllocator;
    class AffineTransform implements Internal.Cloneable, Internal.Serializable {
        constructor()
        constructor(arg0: number[])
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number)
        constructor(arg0: Internal.AffineTransform_)
        constructor(arg0: number[])
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number)
        static getScaleInstance(arg0: number, arg1: number): Internal.AffineTransform;
        setToRotation(arg0: number, arg1: number, arg2: number): void;
        concatenate(arg0: Internal.AffineTransform_): void;
        setToRotation(arg0: number): void;
        static getQuadrantRotateInstance(arg0: number, arg1: number, arg2: number): Internal.AffineTransform;
        transform(arg0: number[], arg1: number, arg2: number[], arg3: number, arg4: number): void;
        setToShear(arg0: number, arg1: number): void;
        static getShearInstance(arg0: number, arg1: number): Internal.AffineTransform;
        transform(arg0: number[], arg1: number, arg2: number[], arg3: number, arg4: number): void;
        preConcatenate(arg0: Internal.AffineTransform_): void;
        createTransformedShape(arg0: Internal.Shape_): Internal.Shape;
        getShearY(): number;
        isIdentity(): boolean;
        getScaleX(): number;
        inverseTransform(arg0: number[], arg1: number, arg2: number[], arg3: number, arg4: number): void;
        setToScale(arg0: number, arg1: number): void;
        invert(): void;
        transform(arg0: Internal.Point2D_, arg1: Internal.Point2D_): Internal.Point2D;
        deltaTransform(arg0: number[], arg1: number, arg2: number[], arg3: number, arg4: number): void;
        transform(arg0: Internal.Point2D_[], arg1: number, arg2: Internal.Point2D_[], arg3: number, arg4: number): void;
        setTransform(arg0: Internal.AffineTransform_): void;
        setToIdentity(): void;
        rotate(arg0: number, arg1: number, arg2: number): void;
        getTranslateY(): number;
        static getQuadrantRotateInstance(arg0: number): Internal.AffineTransform;
        static getRotateInstance(arg0: number): Internal.AffineTransform;
        inverseTransform(arg0: Internal.Point2D_, arg1: Internal.Point2D_): Internal.Point2D;
        setToTranslation(arg0: number, arg1: number): void;
        static getRotateInstance(arg0: number, arg1: number): Internal.AffineTransform;
        setToRotation(arg0: number, arg1: number, arg2: number, arg3: number): void;
        clone(): any;
        setTransform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        scale(arg0: number, arg1: number): void;
        rotate(arg0: number, arg1: number, arg2: number, arg3: number): void;
        getMatrix(arg0: number[]): void;
        deltaTransform(arg0: Internal.Point2D_, arg1: Internal.Point2D_): Internal.Point2D;
        getType(): number;
        static getTranslateInstance(arg0: number, arg1: number): Internal.AffineTransform;
        getScaleY(): number;
        translate(arg0: number, arg1: number): void;
        getShearX(): number;
        transform(arg0: number[], arg1: number, arg2: number[], arg3: number, arg4: number): void;
        quadrantRotate(arg0: number, arg1: number, arg2: number): void;
        createInverse(): this;
        shear(arg0: number, arg1: number): void;
        static getRotateInstance(arg0: number, arg1: number, arg2: number, arg3: number): Internal.AffineTransform;
        setToRotation(arg0: number, arg1: number): void;
        setToQuadrantRotation(arg0: number, arg1: number, arg2: number): void;
        quadrantRotate(arg0: number): void;
        transform(arg0: number[], arg1: number, arg2: number[], arg3: number, arg4: number): void;
        static getRotateInstance(arg0: number, arg1: number, arg2: number): Internal.AffineTransform;
        getTranslateX(): number;
        getDeterminant(): number;
        rotate(arg0: number): void;
        setToQuadrantRotation(arg0: number): void;
        rotate(arg0: number, arg1: number): void;
        set toRotation(arg0: number)
        get shearY(): number
        get identity(): boolean
        get scaleX(): number
        set transform(arg0: Internal.AffineTransform_)
        get translateY(): number
        get type(): number
        get scaleY(): number
        get shearX(): number
        get translateX(): number
        get determinant(): number
        set toQuadrantRotation(arg0: number)
        static readonly TYPE_UNIFORM_SCALE: 2;
        static readonly TYPE_FLIP: 64;
        static readonly TYPE_IDENTITY: 0;
        static readonly TYPE_MASK_SCALE: 6;
        static readonly TYPE_MASK_ROTATION: 24;
        static readonly TYPE_QUADRANT_ROTATION: 8;
        static readonly TYPE_TRANSLATION: 1;
        static readonly TYPE_GENERAL_SCALE: 4;
        static readonly TYPE_GENERAL_TRANSFORM: 32;
        static readonly TYPE_GENERAL_ROTATION: 16;
    }
    type AffineTransform_ = AffineTransform;
    class RecipeBook {
        constructor()
        contains($$0: ResourceLocation_): boolean;
        copyOverData($$0: Internal.RecipeBook_): void;
        removeHighlight($$0: Internal.Recipe_<any>): void;
        remove($$0: Internal.Recipe_<any>): void;
        isOpen($$0: Internal.RecipeBookType_): boolean;
        add($$0: Internal.Recipe_<any>): void;
        addHighlight($$0: Internal.Recipe_<any>): void;
        setOpen($$0: Internal.RecipeBookType_, $$1: boolean): void;
        willHighlight($$0: Internal.Recipe_<any>): boolean;
        contains($$0: Internal.Recipe_<any>): boolean;
        isFiltering($$0: Internal.RecipeBookType_): boolean;
        isFiltering($$0: Internal.RecipeBookMenu_<any>): boolean;
        setFiltering($$0: Internal.RecipeBookType_, $$1: boolean): void;
        setBookSettings($$0: Internal.RecipeBookSettings_): void;
        setBookSetting($$0: Internal.RecipeBookType_, $$1: boolean, $$2: boolean): void;
        getBookSettings(): Internal.RecipeBookSettings;
        set bookSettings($$0: Internal.RecipeBookSettings_)
        get bookSettings(): Internal.RecipeBookSettings
    }
    type RecipeBook_ = RecipeBook;
    interface VisualizationContext {
        abstract createEmbedding(arg0: Vec3i_): Internal.VisualEmbedding;
        abstract instancerProvider(): Internal.InstancerProvider;
        abstract renderOrigin(): Vec3i;
    }
    type VisualizationContext_ = VisualizationContext;
    class ConfigBase$ConfigBool extends Internal.ConfigBase$CValue<boolean, Internal.ForgeConfigSpec$BooleanValue> {
        constructor(this$0: Internal.ConfigBase_, name: string, def: boolean, ...comment: string[])
    }
    type ConfigBase$ConfigBool_ = ConfigBase$ConfigBool;
    class EnterBlockTrigger$TriggerInstance extends Internal.AbstractCriterionTriggerInstance {
        constructor($$0: any_, $$1: Internal.Block_, $$2: any_)
        static entersBlock($$0: Internal.Block_): Internal.EnterBlockTrigger$TriggerInstance;
        matches($$0: Internal.BlockState_): boolean;
    }
    type EnterBlockTrigger$TriggerInstance_ = EnterBlockTrigger$TriggerInstance;
    interface INumericToolStat <T extends number> extends Internal.IToolStat<T> {
        abstract add(arg0: Internal.ModifierStatsBuilder_, arg1: number): void;
        formatColoredMultiplier(loc: string, number: number): net.minecraft.network.chat.Component;
        abstract write(arg0: T): Internal.Tag;
        abstract read(arg0: Internal.Tag_): T;
        formatColoredBonus(loc: string, number: number, scale: number): net.minecraft.network.chat.Component;
        formatNumber(loc: string, color: Internal.TextColor_, number: number): net.minecraft.network.chat.Component;
        abstract getDefaultValue(): T;
        abstract fromNetwork(arg0: Internal.FriendlyByteBuf_): T;
        formatValue(value: T): net.minecraft.network.chat.Component;
        update(arg0: Internal.ModifierStatsBuilder_, arg1: any): void;
        supports(item: Internal.Item_): boolean;
        formatNumber(loc: string, color: Internal.TextColor_, number: number): net.minecraft.network.chat.Component;
        clamp(value: T): T;
        getPrefix(): Internal.MutableComponent;
        getDescription(): Internal.MutableComponent;
        abstract deserialize(arg0: Internal.JsonElement_): T;
        abstract build(arg0: any, arg1: T): T;
        formatNumberPercent(loc: string, color: Internal.TextColor_, number: number): net.minecraft.network.chat.Component;
        abstract getName(): Internal.ToolStatId;
        abstract makeBuilder(): any;
        abstract multiplyAll(arg0: Internal.ModifierStatsBuilder_, arg1: number): void;
        update(builder: Internal.ModifierStatsBuilder_, value: T): void;
        formatValue(arg0: any): net.minecraft.network.chat.Component;
        abstract serialize(arg0: T): Internal.JsonElement;
        abstract toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
        abstract multiply(arg0: Internal.ModifierStatsBuilder_, arg1: number): void;
        abstract formatValue(arg0: number): net.minecraft.network.chat.Component;
        get defaultValue(): T
        get prefix(): Internal.MutableComponent
        get description(): Internal.MutableComponent
        get name(): Internal.ToolStatId
    }
    type INumericToolStat_<T extends number> = INumericToolStat<T>;
    class WaterWheelBlockEntity extends Internal.GeneratingKineticBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        setFlowScoreAndUpdate(score: number): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        applyMaterialIfValid(stack: Internal.ItemStack_): Internal.InteractionResult;
        onLoad(): void;
        getFlowVectorAtPosition(pos: BlockPos_): Vec3d;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        determineAndApplyFlowScore(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        set flowScoreAndUpdate(score: number)
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        static readonly LARGE_OFFSETS: {[key: any]: Internal.HashSet<any>, [key: any]: Internal.HashSet<any>, [key: any]: Internal.HashSet<any>};
        static readonly SMALL_OFFSETS: {[key: any]: Internal.HashSet<any>, [key: any]: Internal.HashSet<any>, [key: any]: Internal.HashSet<any>};
        flowScore: number;
        material: Internal.BlockState;
    }
    type WaterWheelBlockEntity_ = WaterWheelBlockEntity;
    class ChatVisiblity extends Internal.Enum<Internal.ChatVisiblity> implements Internal.OptionEnum {
        static byId($$0: number): Internal.ChatVisiblity;
        getKey(): string;
        static valueOf($$0: string): Internal.ChatVisiblity;
        getCaption(): net.minecraft.network.chat.Component;
        static values(): Internal.ChatVisiblity[];
        getId(): number;
        get key(): string
        get caption(): net.minecraft.network.chat.Component
        get id(): number
        static readonly HIDDEN: Internal.ChatVisiblity;
        static readonly FULL: Internal.ChatVisiblity;
        static readonly SYSTEM: Internal.ChatVisiblity;
    }
    type ChatVisiblity_ = "system" | "full" | "hidden" | ChatVisiblity;
    abstract class BiomeSource implements Internal.BiomeResolver, Internal.IExtendedBiomeSource {
        appendDeferredBiomesList(biomesToAppend: Internal.List_<any>): void;
        findClosestBiome3d($$0: BlockPos_, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Holder<Internal.Biome>>, $$5: Internal.Climate$Sampler_, $$6: Internal.LevelReader_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Holder<Internal.Biome>>;
        possibleBiomes(): Internal.Set<Internal.Holder<Internal.Biome>>;
        getBiomesWithin($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Climate$Sampler_): Internal.Set<Internal.Holder<Internal.Biome>>;
        findBiomeHorizontal($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Holder<Internal.Biome>>, $$5: Internal.RandomSource_, $$6: Internal.Climate$Sampler_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Holder<Internal.Biome>>;
        addDebugInfo($$0: Internal.List_<string>, $$1: BlockPos_, $$2: Internal.Climate$Sampler_): void;
        abstract getNoiseBiome(arg0: number, arg1: number, arg2: number, arg3: Internal.Climate$Sampler_): Internal.Holder<Internal.Biome>;
        findBiomeHorizontal($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: Internal.Predicate_<Internal.Holder<Internal.Biome>>, $$6: Internal.RandomSource_, $$7: boolean, $$8: Internal.Climate$Sampler_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Holder<Internal.Biome>>;
        static readonly CODEC: Internal.Codec<Internal.BiomeSource>;
    }
    type BiomeSource_ = BiomeSource;
    interface AbortableIterationConsumer <T> {
        forConsumer<T>($$0: Internal.Consumer_<T>): this;
        abstract accept(arg0: T): Internal.AbortableIterationConsumer$Continuation;
        (arg0: T): Internal.AbortableIterationConsumer$Continuation_;
    }
    type AbortableIterationConsumer_<T> = AbortableIterationConsumer<T>;
    class LecternDisplayTarget extends Internal.DisplayTarget {
        constructor()
    }
    type LecternDisplayTarget_ = LecternDisplayTarget;
    class RenderStateShard$CullStateShard extends Internal.RenderStateShard$BooleanStateShard {
        constructor($$0: boolean)
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
    }
    type RenderStateShard$CullStateShard_ = RenderStateShard$CullStateShard;
    class ObjectArrayList <K> extends Internal.AbstractObjectList<K> implements Internal.RandomAccess, Internal.Cloneable, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.ObjectList_<K>)
        constructor(arg0: Internal.ObjectCollection_<K>)
        constructor(arg0: K[], arg1: number, arg2: number)
        constructor(arg0: Internal.ObjectIterator_<K>)
        constructor(arg0: K[])
        constructor(arg0: Internal.Iterator_<K>)
        constructor(arg0: number)
        constructor(arg0: Internal.Collection_<K>)
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        setElements(arg0: number, arg1: K[]): void;
        addLast(arg0: K): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        removeLast(): K;
        toArray<K>(arg0: K[]): K[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        spliterator(): Internal.ObjectSpliterator<K>;
        static of<K>(...arg0: K[]): Internal.ObjectArrayList<K>;
        set(arg0: number, arg1: K): K;
        iterator(): Internal.ObjectIterator<any>;
        getFirst(): K;
        parallelStream(): Internal.Stream<K>;
        static of<K>(): Internal.ObjectArrayList<K>;
        listIterator(arg0: number): Internal.ListIterator<any>;
        static wrap<K>(arg0: K[]): Internal.ObjectArrayList<K>;
        removeFirst(): K;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        setElements(arg0: K[]): void;
        reversed(): Internal.SequencedCollection<any>;
        equals(arg0: Internal.ObjectArrayList_<K>): boolean;
        static toListWithExpectedSize<K>(arg0: number): Internal.Collector<K, any, Internal.ObjectArrayList<K>>;
        compareTo(arg0: Internal.ObjectArrayList_<K>): number;
        subList(arg0: number, arg1: number): Internal.ObjectList<K>;
        static of<K>(arg0: K): Internal.ObjectList<K>;
        getLast(): K;
        get(arg0: number): K;
        remove(arg0: number): K;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        addFirst(arg0: K): void;
        static of<K>(arg0: K, arg1: K, arg2: K): Internal.ObjectList<K>;
        static wrap<K>(arg0: K[], arg1: number): Internal.ObjectArrayList<K>;
        elements(): K[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        clone(): this;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        replaceAll(arg0: Internal.UnaryOperator_<K>): void;
        static of<K>(arg0: K, arg1: K): Internal.ObjectList<K>;
        trim(): void;
        addAll(arg0: Internal.ObjectList_<K>): boolean;
        ensureCapacity(arg0: number): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        trim(arg0: number): void;
        static toList<K>(): Internal.Collector<K, any, Internal.ObjectArrayList<K>>;
        stream(): Internal.Stream<K>;
        get first(): K
        set elements(arg0: K[])
        get last(): K
        static readonly DEFAULT_INITIAL_CAPACITY: 10;
    }
    type ObjectArrayList_<K> = ObjectArrayList<K>;
    class MutableComponent implements Internal.ComponentKJS, net.minecraft.network.chat.Component {
        append($$0: net.minecraft.network.chat.Component_): this;
        getVisualOrderText(): Internal.FormattedCharSequence;
        toFlatList(): Internal.List<net.minecraft.network.chat.Component>;
        hasStyle(): boolean;
        darkRed(): this;
        visit<T>($$0: Internal.FormattedText$ContentConsumer_<T>): Internal.Optional<T>;
        toJson(): Internal.JsonElement;
        clickOpenUrl(url: string): this;
        visit<T>($$0: Internal.FormattedText$StyledContentConsumer_<T>, $$1: Internal.Style_): Internal.Optional<T>;
        darkBlue(): this;
        obfuscated(value: boolean): this;
        getString($$0: number): string;
        darkGreen(): this;
        bold(): this;
        color(c: dev.latvian.mods.rhino.mod.util.color.Color_): this;
        underlined(): this;
        static nbt($$0: string, $$1: boolean, $$2: Internal.Optional_<net.minecraft.network.chat.Component>, $$3: Internal.DataSource_): Internal.MutableComponent;
        yellow(): this;
        withStyle($$0: Internal.UnaryOperator_<Internal.Style>): this;
        darkPurple(): this;
        clickCopy(text: string): this;
        blue(): this;
        static translatableWithFallback($$0: string, $$1: string): Internal.MutableComponent;
        hover(s: net.minecraft.network.chat.Component_): this;
        bold(value: boolean): this;
        static score($$0: string, $$1: string): Internal.MutableComponent;
        static create($$0: Internal.ComponentContents_): Internal.MutableComponent;
        getContents(): Internal.ComponentContents;
        withStyle($$0: Internal.ChatFormatting_): this;
        aqua(): this;
        green(): this;
        clickOpenFile(path: string): this;
        static literal($$0: string): Internal.MutableComponent;
        black(): this;
        obfuscated(): this;
        strikethrough(value: boolean): this;
        insertion(s: string): this;
        static translatable($$0: string): Internal.MutableComponent;
        red(): this;
        clickRunCommand(command: string): this;
        italic(): this;
        static translatable($$0: string, ...$$1: any[]): Internal.MutableComponent;
        static empty(): Internal.MutableComponent;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        component(): net.minecraft.network.chat.Component;
        click(s: Internal.ClickEvent_): this;
        isEmpty(): boolean;
        underlined(value: boolean): this;
        asIterable(): Internal.Iterable<net.minecraft.network.chat.Component>;
        getStyle(): Internal.Style;
        self(): this;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        rawComponent(): this;
        gray(): this;
        font(s: ResourceLocation_): this;
        getSiblings(): Internal.List<net.minecraft.network.chat.Component>;
        darkAqua(): this;
        getString(): string;
        static nullToEmpty($$0: string): net.minecraft.network.chat.Component;
        static translatableWithFallback($$0: string, $$1: string, ...$$2: any[]): Internal.MutableComponent;
        static of($$0: string, $$1: Internal.Style_): Internal.FormattedText;
        darkGray(): this;
        clickChangePage(page: string): this;
        noColor(): this;
        plainCopy(): this;
        static keybind($$0: string): Internal.MutableComponent;
        setStyle($$0: Internal.Style_): this;
        withStyle($$0: Internal.Style_): this;
        strikethrough(): this;
        clickSuggestCommand(command: string): this;
        gold(): this;
        contains($$0: net.minecraft.network.chat.Component_): boolean;
        white(): this;
        hasSiblings(): boolean;
        static composite(...$$0: Internal.FormattedText_[]): Internal.FormattedText;
        italic(value: boolean): this;
        static of($$0: string): Internal.FormattedText;
        static composite($$0: Internal.List_<Internal.FormattedText>): Internal.FormattedText;
        withStyle(...$$0: Internal.ChatFormatting_[]): this;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        rawCopy(): this;
        static selector($$0: string, $$1: Internal.Optional_<net.minecraft.network.chat.Component>): Internal.MutableComponent;
        toFlatList($$0: Internal.Style_): Internal.List<net.minecraft.network.chat.Component>;
        lightPurple(): this;
        copy(): this;
        forEach(action: Internal.Consumer_<net.minecraft.network.chat.Component>): void;
        get visualOrderText(): Internal.FormattedCharSequence
        get contents(): Internal.ComponentContents
        get empty(): boolean
        get style(): Internal.Style
        get siblings(): Internal.List<net.minecraft.network.chat.Component>
        get string(): string
        set style($$0: Internal.Style_)
    }
    type MutableComponent_ = MutableComponent;
    class SignText {
        constructor()
        constructor($$0: net.minecraft.network.chat.Component_[], $$1: net.minecraft.network.chat.Component_[], $$2: Internal.DyeColor_, $$3: boolean)
        getRenderMessages($$0: boolean, $$1: Internal.Function_<net.minecraft.network.chat.Component, Internal.FormattedCharSequence>): Internal.FormattedCharSequence[];
        setMessage($$0: number, $$1: net.minecraft.network.chat.Component_): this;
        getColor(): Internal.DyeColor;
        setHasGlowingText($$0: boolean): this;
        hasGlowingText(): boolean;
        setColor($$0: Internal.DyeColor_): this;
        hasMessage($$0: Internal.Player_): boolean;
        getMessages($$0: boolean): net.minecraft.network.chat.Component[];
        setMessage($$0: number, $$1: net.minecraft.network.chat.Component_, $$2: net.minecraft.network.chat.Component_): this;
        getMessage($$0: number, $$1: boolean): net.minecraft.network.chat.Component;
        hasAnyClickCommands($$0: Internal.Player_): boolean;
        get color(): Internal.DyeColor
        set hasGlowingText($$0: boolean)
        set color($$0: Internal.DyeColor_)
        static readonly DIRECT_CODEC: Internal.Codec<Internal.SignText>;
        static readonly LINES: 4;
    }
    type SignText_ = SignText;
    interface ModelStateExtensions {
        getPartTransformation(part: any): Internal.Transformation;
    }
    type ModelStateExtensions_ = ModelStateExtensions;
    class BaseFactoryBlock extends Internal.Block {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly ON: Internal.BooleanProperty;
    }
    type BaseFactoryBlock_ = BaseFactoryBlock;
    class SculkSensorBlock extends Internal.BaseEntityBlock implements Internal.SimpleWaterloggedBlock, Internal.CustomExpBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static canActivate($$0: Internal.BlockState_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getActiveTicks(): number;
        setLightEmission(v: number): void;
        getMod(): string;
        activate($$0: Internal.Entity_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: number, $$5: number): void;
        static tryResonateVibration($$0: Internal.Entity_, $$1: Internal.Level_, $$2: BlockPos_, $$3: number): void;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        static getPhase($$0: Internal.BlockState_): Internal.SculkSensorPhase;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getExpDrop(state: Internal.BlockState_, level: Internal.LevelReader_, randomSource: Internal.RandomSource_, pos: BlockPos_, fortuneLevel: number, silkTouchLevel: number): number;
        setDestroySpeed(v: number): void;
        static deactivate($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get activeTicks(): number
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly COOLDOWN_TICKS: 10;
        static readonly ACTIVE_TICKS: 30;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly POWER: Internal.IntegerProperty;
        static readonly PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    }
    type SculkSensorBlock_ = SculkSensorBlock;
    abstract class NearestVisibleLivingEntitySensor extends Internal.Sensor<Internal.LivingEntity> {
        constructor()
    }
    type NearestVisibleLivingEntitySensor_ = NearestVisibleLivingEntitySensor;
    class SideConfig {
        constructor(storage: Internal.AbstractEnergyStorage_<any, any>)
        getType(side: Internal.Direction_): Internal.Transfer;
        write(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        read(nbt: Internal.CompoundTag_): void;
        init(): void;
        nextTypeAll(): void;
        nextType(side: Internal.Direction_): void;
        setType(side: Internal.Direction_, type: Internal.Transfer_): void;
        isAllEquals(): boolean;
        get allEquals(): boolean
    }
    type SideConfig_ = SideConfig;
    class ShapelessRecipeBuilder extends Internal.CraftingRecipeBuilder implements Internal.RecipeBuilder {
        constructor($$0: Internal.RecipeCategory_, $$1: Internal.ItemLike_, $$2: number)
        requires($$0: Internal.TagKey_<Internal.Item>): this;
        save($$0: Internal.Consumer_<Internal.FinishedRecipe>, $$1: string): void;
        static getDefaultRecipeId($$0: Internal.ItemLike_): ResourceLocation;
        requires($$0: Internal.Ingredient_): this;
        getResult(): Internal.Item;
        group(arg0: string): Internal.RecipeBuilder;
        unlockedBy($$0: string, $$1: Internal.CriterionTriggerInstance_): this;
        static shapeless($$0: Internal.RecipeCategory_, $$1: Internal.ItemLike_): Internal.ShapelessRecipeBuilder;
        requires($$0: Internal.ItemLike_): this;
        static shapeless($$0: Internal.RecipeCategory_, $$1: Internal.ItemLike_, $$2: number): Internal.ShapelessRecipeBuilder;
        group($$0: string): this;
        save($$0: Internal.Consumer_<Internal.FinishedRecipe>): void;
        requires($$0: Internal.ItemLike_, $$1: number): this;
        requires($$0: Internal.Ingredient_, $$1: number): this;
        save($$0: Internal.Consumer_<Internal.FinishedRecipe>, $$1: ResourceLocation_): void;
        unlockedBy(arg0: string, arg1: Internal.CriterionTriggerInstance_): Internal.RecipeBuilder;
        get result(): Internal.Item
    }
    type ShapelessRecipeBuilder_ = ShapelessRecipeBuilder;
    interface ObjectIterator <K> extends Internal.Iterator<K> {
        remove(): void;
        skip(arg0: number): number;
        abstract next(): K;
        abstract hasNext(): boolean;
        forEachRemaining(arg0: Internal.Consumer_<K>): void;
    }
    type ObjectIterator_<K> = ObjectIterator<K>;
    class AgriRequirement$Builder {
        constructor()
        dimensions(ingnoreFromStrength: number, blacklist: boolean, ...dimensions: ResourceLocation_[]): this;
        biomes(...biomes: ResourceLocation_[]): this;
        build(): Internal.AgriRequirement;
        dimensions(blacklist: boolean, ...dimensions: ResourceLocation_[]): this;
        fluid(fluid: Internal.AgriFluidCondition_): this;
        seasons(...seasons: Internal.AgriSeason_[]): this;
        nutrients(condition: Internal.AgriSoilCondition$Nutrients_, type: Internal.AgriSoilCondition$Type_, toleranceFactor: number): this;
        biomes(blacklist: boolean, ...biomes: ResourceLocation_[]): this;
        acidity(condition: Internal.AgriSoilCondition$Acidity_, type: Internal.AgriSoilCondition$Type_, toleranceFactor: number): this;
        dimensions(...dimensions: ResourceLocation_[]): this;
        biomes(ingnoreFromStrength: number, blacklist: boolean, ...biomes: ResourceLocation_[]): this;
        blocks(...blocks: Internal.AgriBlockCondition_[]): this;
        light(min: number, max: number, toleranceFactor: number): this;
        humidity(condition: Internal.AgriSoilCondition$Humidity_, type: Internal.AgriSoilCondition$Type_, toleranceFactor: number): this;
    }
    type AgriRequirement$Builder_ = AgriRequirement$Builder;
    interface SignatureUpdater$Output {
        abstract update(arg0: number[]): void;
        (arg0: number[]): void;
    }
    type SignatureUpdater$Output_ = SignatureUpdater$Output;
    abstract class AbstractRecipeSerializer <T extends Internal.Recipe<any>> implements Internal.RecipeSerializer<T> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        abstract fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): T;
        abstract fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): T;
        abstract toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
    }
    type AbstractRecipeSerializer_<T extends Internal.Recipe<any>> = AbstractRecipeSerializer<T>;
    class RandomPatchConfiguration extends Internal.Record implements Internal.FeatureConfiguration {
        constructor($$0: number, $$1: number, $$2: number, $$3: Internal.Holder_<Internal.PlacedFeature>)
        tries(): number;
        ySpread(): number;
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        feature(): Internal.Holder<Internal.PlacedFeature>;
        xzSpread(): number;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.RandomPatchConfiguration>;
    }
    type RandomPatchConfiguration_ = RandomPatchConfiguration;
    class ChainConveyorRoutingTable$RoutingTableEntry extends Internal.Record {
        constructor(port: string, distance: number, nextConnection: BlockPos_, timeout: Internal.MutableInt_, endOfRoute: boolean)
        distance(): number;
        endOfRoute(): boolean;
        copyForNeighbour(connection: BlockPos_): this;
        timeout(): Internal.MutableInt;
        nextConnection(): BlockPos;
        invalid(): boolean;
        port(): string;
        tick(): void;
    }
    type ChainConveyorRoutingTable$RoutingTableEntry_ = ChainConveyorRoutingTable$RoutingTableEntry;
    interface SectionedEntityMovementListener {
        abstract handleEntityMovement(arg0: typeof any): void;
        (arg0: typeof any): void;
    }
    type SectionedEntityMovementListener_ = SectionedEntityMovementListener;
    class ModCheck$Confidence extends Internal.Enum<Internal.ModCheck$Confidence> {
        static values(): Internal.ModCheck$Confidence[];
        static valueOf($$0: string): Internal.ModCheck$Confidence;
        static readonly VERY_LIKELY: Internal.ModCheck$Confidence;
        static readonly DEFINITELY: Internal.ModCheck$Confidence;
        static readonly PROBABLY_NOT: Internal.ModCheck$Confidence;
    }
    type ModCheck$Confidence_ = "definitely" | "very_likely" | ModCheck$Confidence | "probably_not";
    class Ti69Item extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly APP: Internal.SensorApp;
    }
    type Ti69Item_ = Ti69Item;
    class AbuseReportRequest$ThirdPartyServerInfo {
        constructor(arg0: string)
        address: string;
    }
    type AbuseReportRequest$ThirdPartyServerInfo_ = AbuseReportRequest$ThirdPartyServerInfo;
    class WeatheringPlatformBlock extends Internal.PlatformBlock implements Internal.WeatheringCopper {
        constructor(age: Internal.WeatheringCopper$WeatherState_, props: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        applyChangeOverTime($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getAge(): Internal.WeatheringCopper$WeatherState;
        getNext(state: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        static getPrevious($$0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        onRandomTick($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static getPrevious($$0: Internal.Block_): Internal.Optional<Internal.Block>;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getAge(): Internal.Enum<any>;
        setDestroySpeed(v: number): void;
        static getFirst($$0: Internal.Block_): Internal.Block;
        static getNext($$0: Internal.Block_): Internal.Optional<Internal.Block>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getFirst($$0: Internal.BlockState_): Internal.BlockState;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getToolModifiedState(player: Internal.Player_, world: Internal.Level_, hand: Internal.InteractionHand_, hitResult: Internal.BlockHitResult_): Internal.InteractionResult;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getChanceModifier(): number;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        get age(): Internal.WeatheringCopper$WeatherState
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get age(): Internal.Enum<any>
        set destroySpeed(v: number)
        get chanceModifier(): number
    }
    type WeatheringPlatformBlock_ = WeatheringPlatformBlock;
    class Ghast extends Internal.FlyingMob implements Internal.Enemy {
        constructor($$0: Internal.EntityType_<Internal.Ghast>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        getExplosionPower(): number;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        setCharging($$0: boolean): void;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        static checkGhastSpawnRules($$0: Internal.EntityType_<Internal.Ghast>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        isCharging(): boolean;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get explosionPower(): number
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set charging($$0: boolean)
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get charging(): boolean
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Ghast_ = Ghast;
    class BlockIngredientBuffer extends Internal.BlockBaseGui<Internal.TileIngredientBuffer> {
        constructor()
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        openGui(tile: Internal.TileIngredientBuffer_, p: Internal.Player_): void;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockIngredientBuffer_ = BlockIngredientBuffer;
    interface ScreenEvents$BeforeRender {
        abstract beforeRender(arg0: Internal.Screen_, arg1: Internal.GuiGraphics_, arg2: number, arg3: number, arg4: number): void;
        (arg0: Internal.Screen, arg1: Internal.GuiGraphics, arg2: number, arg3: number, arg4: number): void;
    }
    type ScreenEvents$BeforeRender_ = ScreenEvents$BeforeRender;
    interface ConcretePowderBlockAccessor {
        abstract create$getConcrete(): Internal.BlockState;
        (): Internal.BlockState_;
    }
    type ConcretePowderBlockAccessor_ = ConcretePowderBlockAccessor;
    class SawBlockEntity extends Internal.BlockBreakingKineticBlockEntity implements Internal.SidedStorageBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        insertItem(entity: Internal.ItemEntity_): void;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getItemMovementVec(): Vec3d;
        dropItemFromCutTree(pos: BlockPos_, stack: Internal.ItemStack_): void;
        static isSawable(stateToBreak: Internal.BlockState_): boolean;
        onLoad(): void;
        getItemStorage(face: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        start(inserted: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get itemMovementVec(): Vec3d
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        static readonly woodcuttingRecipeType: Internal.Supplier<Internal.RecipeType<any>>;
        inventory: Internal.ProcessingInventory;
    }
    type SawBlockEntity_ = SawBlockEntity;
    class PortingLibCreativeTab$TabData extends Internal.Record {
        constructor(tabsImage: ResourceLocation_, labelColor: number, slotColor: number, tabsBefore: Internal.List_<ResourceLocation>, tabsAfter: Internal.List_<ResourceLocation>)
        slotColor(): number;
        labelColor(): number;
        tabsImage(): ResourceLocation;
        tabsAfter(): Internal.List<ResourceLocation>;
        tabsBefore(): Internal.List<ResourceLocation>;
    }
    type PortingLibCreativeTab$TabData_ = PortingLibCreativeTab$TabData;
    interface IPatternDetails$PatternInputSink {
        abstract pushInput(arg0: Internal.AEKey_, arg1: number): void;
        (arg0: Internal.AEKey, arg1: number): void;
    }
    type IPatternDetails$PatternInputSink_ = IPatternDetails$PatternInputSink;
    class PistonStructureResolver {
        constructor($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.Direction_, $$3: boolean)
        getPushDirection(): Internal.Direction;
        getToPush(): Internal.List<BlockPos>;
        resolve(): boolean;
        getToDestroy(): Internal.List<BlockPos>;
        get pushDirection(): Internal.Direction
        get toPush(): Internal.List<BlockPos>
        get toDestroy(): Internal.List<BlockPos>
        static readonly MAX_PUSH_DEPTH: 12;
    }
    type PistonStructureResolver_ = PistonStructureResolver;
    class GenerationStep$Carving extends Internal.Enum<Internal.GenerationStep$Carving> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        getName(): string;
        static valueOf($$0: string): Internal.GenerationStep$Carving;
        static values(): Internal.GenerationStep$Carving[];
        get serializedName(): string
        get name(): string
        static readonly AIR: Internal.GenerationStep$Carving;
        static readonly LIQUID: Internal.GenerationStep$Carving;
        static readonly CODEC: Internal.Codec<Internal.GenerationStep$Carving>;
    }
    type GenerationStep$Carving_ = "liquid" | "air" | GenerationStep$Carving;
    class SnowshoesItem extends Internal.WearableArtifactItem {
        constructor()
        static getModifiedFriction(friction: number, entity: Internal.LivingEntity_, block: Internal.Block_): number;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SnowshoesItem_ = SnowshoesItem;
    class CarpetBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CarpetBlock_ = CarpetBlock;
    class Variant extends Internal.Enum<Internal.Variant> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.Variant[];
        getSerializedName(): string;
        static valueOf($$0: string): Internal.Variant;
        static byId($$0: number): Internal.Variant;
        getId(): number;
        get serializedName(): string
        get id(): number
        static readonly CODEC: Internal.Codec<Internal.Variant>;
        static readonly WHITE: Internal.Variant;
        static readonly BLACK: Internal.Variant;
        static readonly DARK_BROWN: Internal.Variant;
        static readonly CREAMY: Internal.Variant;
        static readonly BROWN: Internal.Variant;
        static readonly GRAY: Internal.Variant;
        static readonly CHESTNUT: Internal.Variant;
    }
    type Variant_ = Variant | "white" | "brown" | "gray" | "black" | "dark_brown" | "creamy" | "chestnut";
    class RenderStateShard$DepthTestStateShard extends Internal.RenderStateShard {
        constructor($$0: string, $$1: number)
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
    }
    type RenderStateShard$DepthTestStateShard_ = RenderStateShard$DepthTestStateShard;
    interface PalettedContainerRO <T> {
        abstract recreate(): Internal.PalettedContainer<T>;
        abstract maybeHas(arg0: Internal.Predicate_<T>): boolean;
        abstract write(arg0: Internal.FriendlyByteBuf_): void;
        abstract getSerializedSize(): number;
        abstract pack(arg0: Internal.IdMap_<T>, arg1: Internal.PalettedContainer$Strategy_): Internal.PalettedContainerRO$PackedData<T>;
        abstract getAll(arg0: Internal.Consumer_<T>): void;
        abstract count(arg0: Internal.PalettedContainer$CountConsumer_<T>): void;
        abstract get(arg0: number, arg1: number, arg2: number): T;
        get serializedSize(): number
    }
    type PalettedContainerRO_<T> = PalettedContainerRO<T>;
    class LevelChunk$EntityCreationType extends Internal.Enum<Internal.LevelChunk$EntityCreationType> {
        static valueOf($$0: string): Internal.LevelChunk$EntityCreationType;
        static values(): Internal.LevelChunk$EntityCreationType[];
        static readonly IMMEDIATE: Internal.LevelChunk$EntityCreationType;
        static readonly QUEUED: Internal.LevelChunk$EntityCreationType;
        static readonly CHECK: Internal.LevelChunk$EntityCreationType;
    }
    type LevelChunk$EntityCreationType_ = "check" | "immediate" | LevelChunk$EntityCreationType | "queued";
    class UpgradeCardItem extends Internal.AEBaseItem implements Internal.AEToolItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type UpgradeCardItem_ = UpgradeCardItem;
    class LiteralCommandNode <S> extends Internal.CommandNode<S> {
        constructor(arg0: string, arg1: Internal.Command_<S>, arg2: Internal.Predicate_<S>, arg3: Internal.CommandNode_<S>, arg4: Internal.RedirectModifier_<S>, arg5: boolean)
        isValidInput(arg0: string): boolean;
        createBuilder(): Internal.ArgumentBuilder<any, any>;
        getLiteral(): string;
        get literal(): string
    }
    type LiteralCommandNode_<S> = LiteralCommandNode<S>;
    class SingleItemRecipe$Serializer <T extends Internal.SingleItemRecipe> implements Internal.RecipeSerializer<T> {
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson($$0: ResourceLocation_, $$1: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetwork($$0: ResourceLocation_, $$1: Internal.FriendlyByteBuf_): T;
        toNetwork($$0: Internal.FriendlyByteBuf_, $$1: T): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type SingleItemRecipe$Serializer_<T extends Internal.SingleItemRecipe> = SingleItemRecipe$Serializer<T>;
    interface Byte2LongFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntToLongFunction {
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeInt(arg0: Internal.Int2ByteFunction_): Internal.Int2LongFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Byte2ObjectFunction<T>;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeFloat(arg0: Internal.Float2ByteFunction_): Internal.Float2LongFunction;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Byte2ShortFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Byte2ByteFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        containsKey(arg0: number): boolean;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Byte2IntFunction;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Byte2CharFunction;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Byte2FloatFunction;
        getOrDefault(arg0: number, arg1: number): number;
        composeChar(arg0: Internal.Char2ByteFunction_): Internal.Char2LongFunction;
        put(arg0: number, arg1: number): number;
        defaultReturnValue(): number;
        abstract get(arg0: number): number;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Byte2ReferenceFunction<T>;
        composeReference<T>(arg0: Internal.Reference2ByteFunction_<T>): Internal.Reference2LongFunction<T>;
        composeObject<T>(arg0: Internal.Object2ByteFunction_<T>): Internal.Object2LongFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Byte2DoubleFunction;
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        composeLong(arg0: Internal.Long2ByteFunction_): Internal.Long2LongFunction;
        size(): number;
        composeByte(arg0: Internal.Byte2ByteFunction_): this;
        /**
         * @deprecated
        */
        applyAsLong(arg0: number): number;
        clear(): void;
        apply(arg0: number): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        composeDouble(arg0: Internal.Double2ByteFunction_): Internal.Double2LongFunction;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        composeShort(arg0: Internal.Short2ByteFunction_): Internal.Short2LongFunction;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        (arg0: number): number;
    }
    type Byte2LongFunction_ = Byte2LongFunction;
    class MapItemSavedData extends Internal.SavedData implements Internal.ExpandedMapData, Internal.StationMapData {
        static createForClient($$0: number, $$1: boolean, $$2: Internal.ResourceKey_<Internal.Level>): Internal.MapItemSavedData;
        handler$fen000$moonlight$locked(cir: Internal.CallbackInfoReturnable_<any>): void;
        getCustomMarkers(): Internal.Map<any, any>;
        handler$fen000$moonlight$checkCustomDeco(world: Internal.BlockGetter_, x: number, z: number, ci: Internal.CallbackInfo_): void;
        getDecorations(): Internal.Iterable<Internal.MapDecoration>;
        tickCarriedBy($$0: Internal.Player_, $$1: Internal.ItemStack_): void;
        addClientSideDecorations($$0: Internal.List_<Internal.MapDecoration>): void;
        setColor($$0: number, $$1: number, $$2: number): void;
        handler$hnc000$create$onSave(compound: Internal.CompoundTag_, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$fen000$moonlight$save(tag: Internal.CompoundTag_, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$fen000$moonlight$scaled(cir: Internal.CallbackInfoReturnable_<any>): void;
        toggleBanner($$0: Internal.LevelAccessor_, $$1: BlockPos_): boolean;
        copy(): this;
        toggleStation(level: Internal.LevelAccessor_, pos: BlockPos_, stationBlockEntity: Internal.StationBlockEntity_): boolean;
        handler$fen000$moonlight$initCustomData(i: number, j: number, b: number, bl: boolean, bl2: boolean, bl3: boolean, resourceKey: Internal.ResourceKey_<any>, ci: Internal.CallbackInfo_): void;
        scaled($$0: number): this;
        getUpdatePacket($$0: number, $$1: Internal.Player_): Internal.Packet<any>;
        resetCustomDecoration(): void;
        toggleCustomDecoration(world: Internal.LevelAccessor_, pos: BlockPos_): boolean;
        static load($$0: Internal.CompoundTag_): Internal.MapItemSavedData;
        isTrackedCountOverLimit($$0: number): boolean;
        getVanillaDecorationSize(): number;
        handler$fen000$moonlight$tickCarriedBy(player: Internal.Player_, stack: Internal.ItemStack_, ci: Internal.CallbackInfo_): void;
        handler$hnc000$create$onCheckBanners(blockGetter: Internal.BlockGetter_, x: number, z: number, ci: Internal.CallbackInfo_): void;
        getCustomData(): Internal.Map<any, any>;
        updateColor($$0: number, $$1: number, $$2: number): boolean;
        static addTargetDecoration($$0: Internal.ItemStack_, $$1: BlockPos_, $$2: string, $$3: Internal.MapDecoration$Type_): void;
        removedFromFrame($$0: BlockPos_, $$1: number): void;
        addCustomMarker(marker: Internal.MapBlockMarker_<any>): void;
        getHoldingPlayer($$0: Internal.Player_): Internal.MapItemSavedData$HoldingPlayer;
        addDecoration($$0: Internal.MapDecoration$Type_, $$1: Internal.LevelAccessor_, $$2: string, $$3: number, $$4: number, $$5: number, $$6: net.minecraft.network.chat.Component_): void;
        getCustomDecorations(): Internal.Map<any, any>;
        addStationMarker(marker: Internal.StationMarker_): void;
        isExplorationMap(): boolean;
        checkBanners($$0: Internal.BlockGetter_, $$1: number, $$2: number): void;
        removeCustomMarker(key: string): boolean;
        setCustomDataDirty(type: Internal.CustomMapData$Type_<any>, dirtySetter: Internal.Consumer_<any>): void;
        locked(): this;
        getBanners(): Internal.Collection<Internal.MapBanner>;
        setCustomDecorationsDirty(): void;
        static createFresh($$0: number, $$1: number, $$2: number, $$3: boolean, $$4: boolean, $$5: Internal.ResourceKey_<Internal.Level>): Internal.MapItemSavedData;
        get customMarkers(): Internal.Map<any, any>
        get decorations(): Internal.Iterable<Internal.MapDecoration>
        get vanillaDecorationSize(): number
        get customData(): Internal.Map<any, any>
        get customDecorations(): Internal.Map<any, any>
        get explorationMap(): boolean
        get banners(): Internal.Collection<Internal.MapBanner>
        colors: number[];
        static readonly MAX_SCALE: 4;
        readonly scale: number;
        readonly moonlight$customData: Internal.Map<any, any>;
        readonly locked: boolean;
        centerZ: number;
        dimension: Internal.ResourceKey<Internal.Level>;
        static readonly TRACKED_DECORATION_LIMIT: 256;
        moonlight$customDecorations: Internal.Map<any, any>;
        centerX: number;
    }
    type MapItemSavedData_ = MapItemSavedData;
    interface GeckoLibNetwork$IPacketCallback {
        abstract onReadyToSend(arg0: Internal.AbstractPacket_): void;
        (arg0: Internal.AbstractPacket): void;
    }
    type GeckoLibNetwork$IPacketCallback_ = GeckoLibNetwork$IPacketCallback;
    class Quaterniond implements Internal.Cloneable, Internal.Externalizable, Internal.Quaterniondc {
        constructor()
        constructor(arg0: Internal.AxisAngle4d_)
        constructor(arg0: Internal.Quaternionfc_)
        constructor(arg0: number, arg1: number, arg2: number, arg3: number)
        constructor(arg0: Internal.AxisAngle4f_)
        constructor(arg0: Internal.Quaterniondc_)
        rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Quaterniond_): this;
        scaling(arg0: number): this;
        invert(): this;
        transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
        transformPositiveY(arg0: Vec3f_): Vec3f;
        transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
        mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
        get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
        setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
        transform(arg0: Internal.Vector4d_): Internal.Vector4d;
        static slerp(arg0: Internal.Quaterniond_[], arg1: number[], arg2: Internal.Quaterniond_): Internal.Quaterniondc;
        x(): number;
        transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
        transformPositiveY(arg0: Vec4f_): Vec4f;
        dot(arg0: Internal.Quaterniondc_): number;
        transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
        transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        rotationX(arg0: number): this;
        rotateY(arg0: number, arg1: Internal.Quaterniond_): this;
        rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
        transform(arg0: Internal.Vector3d_): Internal.Vector3d;
        positiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        rotateY(arg0: number): this;
        setFromNormalized(arg0: Internal.Matrix3dc_): this;
        normalize(): this;
        rotateYXZ(arg0: number, arg1: number, arg2: number): this;
        premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
        rotateAxis(arg0: number, arg1: Internal.Vector3dc_): this;
        rotateTo(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Quaterniond_): this;
        transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        transformPositiveZ(arg0: Vec3f_): Vec3f;
        transformUnit(arg0: Vec4f_): Vec4f;
        difference(arg0: Internal.Quaterniondc_): this;
        get(arg0: Matrix4f_): Matrix4f;
        conjugate(arg0: Internal.Quaterniond_): this;
        transform(arg0: Vec4f_): Vec4f;
        transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        rotationAxis(arg0: Internal.AxisAngle4f_): this;
        setFromNormalized(arg0: Internal.Matrix4fc_): this;
        transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        fromAxisAngleRad(arg0: Internal.Vector3dc_, arg1: number): this;
        static nlerp(arg0: Internal.Quaterniond_[], arg1: number[], arg2: Internal.Quaterniond_): Internal.Quaterniondc;
        y(): number;
        transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
        rotationYXZ(arg0: number, arg1: number, arg2: number): this;
        transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        transformPositiveZ(arg0: Vec4f_): Vec4f;
        transformUnit(arg0: Internal.Vector3d_): Internal.Vector3d;
        rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        lookAlong(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        rotateZ(arg0: number, arg1: Internal.Quaterniond_): this;
        transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaterniond_): this;
        transform(arg0: Vec3f_): Vec3f;
        positiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        rotateZ(arg0: number): this;
        getEulerAnglesZXY(arg0: Internal.Vector3d_): Internal.Vector3d;
        transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        scale(arg0: number): this;
        rotateAxis(arg0: number, arg1: Internal.Vector3dc_, arg2: Internal.Quaterniond_): this;
        z(): number;
        transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
        isFinite(): boolean;
        setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
        transformUnitPositiveX(arg0: Vec3f_): Vec3f;
        equals(arg0: Internal.Quaterniondc_, arg1: number): boolean;
        normalize(arg0: Internal.Quaterniond_): this;
        get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
        rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaterniond_): this;
        transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
        transformUnit(arg0: Vec3f_): Vec3f;
        rotationZ(arg0: number): this;
        conjugateBy(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): this;
        transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
        setFromNormalized(arg0: Internal.Matrix3fc_): this;
        transformInverse(arg0: Vec4f_): Vec4f;
        premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): this;
        transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): this;
        difference(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): this;
        setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
        slerp(arg0: Internal.Quaterniondc_, arg1: number, arg2: Internal.Quaterniond_): this;
        transformInverse(arg0: Vec3f_): Vec3f;
        rotateX(arg0: number, arg1: Internal.Quaterniond_): this;
        integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): this;
        transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        rotationY(arg0: number): this;
        getEulerAnglesYXZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        scale(arg0: number, arg1: Internal.Quaterniond_): this;
        transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
        rotateX(arg0: number): this;
        conjugate(): this;
        nlerp(arg0: Internal.Quaterniondc_, arg1: number): this;
        mul(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): this;
        transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        div(arg0: Internal.Quaterniondc_): this;
        rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaterniond_): this;
        transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
        transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        mul(arg0: Internal.Quaterniondc_): this;
        transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        mul(arg0: number, arg1: Internal.Quaterniond_): this;
        rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): this;
        premul(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): this;
        mul(arg0: number): this;
        mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): this;
        lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Quaterniond_): this;
        transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        toString(arg0: Internal.NumberFormat_): string;
        transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        transformInverseUnit(arg0: Vec3f_): Vec3f;
        transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
        rotateTo(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
        get(arg0: Quaternionf_): Quaternionf;
        transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
        transformUnitPositiveY(arg0: Vec4f_): Vec4f;
        premul(arg0: Internal.Quaterniondc_): this;
        div(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): this;
        identity(): this;
        clone(): any;
        writeExternal(arg0: Internal.ObjectOutput_): void;
        set(arg0: number, arg1: number, arg2: number, arg3: number): this;
        angle(): number;
        add(arg0: Internal.Quaterniondc_): this;
        slerp(arg0: Internal.Quaterniondc_, arg1: number): this;
        set(arg0: Internal.Quaternionfc_): this;
        transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        transformInverseUnit(arg0: Vec4f_): Vec4f;
        transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        rotationTo(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        rotationXYZ(arg0: number, arg1: number, arg2: number): this;
        transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
        transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        transformUnitPositiveY(arg0: Vec3f_): Vec3f;
        lengthSquared(): number;
        get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
        normalizedPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        rotateXYZ(arg0: number, arg1: number, arg2: number): this;
        getEulerAnglesZYX(arg0: Internal.Vector3d_): Internal.Vector3d;
        transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        nlerpIterative(arg0: Internal.Quaterniondc_, arg1: number, arg2: number): this;
        setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
        transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        transformInverseUnit(arg0: Internal.Vector3d_): Internal.Vector3d;
        transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        static nlerpIterative(arg0: Internal.Quaterniondc_[], arg1: number[], arg2: number, arg3: Internal.Quaterniond_): Internal.Quaterniond;
        equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        transformUnitPositiveX(arg0: Vec4f_): Vec4f;
        rotateLocalZ(arg0: number, arg1: Internal.Quaterniond_): this;
        rotateZYX(arg0: number, arg1: number, arg2: number): this;
        rotateLocalZ(arg0: number): this;
        setAngleAxis(arg0: number, arg1: Internal.Vector3dc_): this;
        rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        nlerp(arg0: Internal.Quaterniondc_, arg1: number, arg2: Internal.Quaterniond_): this;
        nlerpIterative(arg0: Internal.Quaterniondc_, arg1: number, arg2: number, arg3: Internal.Quaterniond_): this;
        normalizedPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
        set(arg0: Internal.AxisAngle4f_): this;
        readExternal(arg0: Internal.ObjectInput_): void;
        transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        fromAxisAngleDeg(arg0: Internal.Vector3dc_, arg1: number): this;
        rotateLocalY(arg0: number): this;
        get(arg0: Matrix3f_): Matrix3f;
        rotateLocalY(arg0: number, arg1: Internal.Quaterniond_): this;
        transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
        add(arg0: number, arg1: number, arg2: number, arg3: number): this;
        transformPositiveX(arg0: Vec3f_): Vec3f;
        getEulerAnglesXYZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        set(arg0: Internal.Quaterniondc_): this;
        transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        add(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): this;
        transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        w(): number;
        setFromNormalized(arg0: Internal.Matrix4dc_): this;
        transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        conjugateBy(arg0: Internal.Quaterniondc_): this;
        normalizedPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        set(arg0: Internal.AxisAngle4d_): this;
        transformPositiveX(arg0: Vec4f_): Vec4f;
        invert(arg0: Internal.Quaterniond_): this;
        lookAlong(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Quaterniond_): this;
        setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
        rotateLocalX(arg0: number): this;
        rotateLocalX(arg0: number, arg1: Internal.Quaterniond_): this;
        rotationZYX(arg0: number, arg1: number, arg2: number): this;
        positiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
        get(arg0: Internal.Quaterniond_): this;
        rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
        transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
        integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
        set fromUnnormalized(arg0: Internal.Matrix3fc_)
        set fromNormalized(arg0: Internal.Matrix3dc_)
        set fromNormalized(arg0: Internal.Matrix4fc_)
        get finite(): boolean
        set fromUnnormalized(arg0: Internal.Matrix3dc_)
        set fromUnnormalized(arg0: Internal.Matrix4fc_)
        set fromNormalized(arg0: Internal.Matrix3fc_)
        set fromNormalized(arg0: Internal.Matrix4x3fc_)
        set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
        set fromUnnormalized(arg0: Internal.Matrix4dc_)
        set fromNormalized(arg0: Internal.Matrix4x3dc_)
        set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
        set fromNormalized(arg0: Internal.Matrix4dc_)
        z: number;
        w: number;
        x: number;
        y: number;
    }
    type Quaterniond_ = Quaterniond;
    class RenderingHints implements Internal.Cloneable, Internal.Map<any, any> {
        constructor(arg0: Internal.Map_<Internal.RenderingHints$Key, any>)
        constructor(arg0: Internal.RenderingHints$Key_, arg1: any)
        clone(): any;
        containsValue(arg0: any): boolean;
        static of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: any): any;
        putAll(arg0: Internal.Map_<any, any>): void;
        isEmpty(): boolean;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        containsKey(arg0: any): boolean;
        keySet(): Internal.Set<any>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        replaceAll(arg0: Internal.BiFunction_<any, any, any>): void;
        replace(arg0: any, arg1: any, arg2: any): boolean;
        put(arg0: any, arg1: any): any;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        values(): Internal.Collection<any>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        add(arg0: Internal.RenderingHints_): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        computeIfAbsent(arg0: any, arg1: Internal.Function_<any, any>): any;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        size(): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        forEach(arg0: Internal.BiConsumer_<any, any>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        entrySet(): Internal.Set<Internal.Map$Entry<any, any>>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        replace(arg0: any, arg1: any): any;
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        remove(arg0: any): any;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        get(arg0: any): any;
        compute(arg0: any, arg1: Internal.BiFunction_<any, any, any>): any;
        computeIfPresent(arg0: any, arg1: Internal.BiFunction_<any, any, any>): any;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        putIfAbsent(arg0: any, arg1: any): any;
        get empty(): boolean
        static readonly VALUE_TEXT_ANTIALIAS_ON: Internal.SunHints$Value;
        static readonly VALUE_COLOR_RENDER_SPEED: Internal.SunHints$Value;
        static readonly VALUE_TEXT_ANTIALIAS_OFF: Internal.SunHints$Value;
        static readonly VALUE_COLOR_RENDER_DEFAULT: Internal.SunHints$Value;
        static readonly KEY_TEXT_LCD_CONTRAST: Internal.SunHints$LCDContrastKey;
        static readonly VALUE_RESOLUTION_VARIANT_DEFAULT: Internal.SunHints$Value;
        static readonly VALUE_ALPHA_INTERPOLATION_SPEED: Internal.SunHints$Value;
        static readonly KEY_RESOLUTION_VARIANT: Internal.SunHints$Key;
        static readonly VALUE_TEXT_ANTIALIAS_LCD_VBGR: Internal.SunHints$Value;
        static readonly VALUE_ALPHA_INTERPOLATION_QUALITY: Internal.SunHints$Value;
        static readonly VALUE_TEXT_ANTIALIAS_LCD_HBGR: Internal.SunHints$Value;
        static readonly KEY_COLOR_RENDERING: Internal.SunHints$Key;
        static readonly VALUE_FRACTIONALMETRICS_ON: Internal.SunHints$Value;
        static readonly VALUE_RENDER_DEFAULT: Internal.SunHints$Value;
        static readonly VALUE_DITHER_DEFAULT: Internal.SunHints$Value;
        static readonly KEY_FRACTIONALMETRICS: Internal.SunHints$Key;
        static readonly VALUE_INTERPOLATION_BILINEAR: Internal.SunHints$Value;
        static readonly VALUE_TEXT_ANTIALIAS_LCD_HRGB: Internal.SunHints$Value;
        static readonly KEY_ALPHA_INTERPOLATION: Internal.SunHints$Key;
        static readonly VALUE_ANTIALIAS_OFF: Internal.SunHints$Value;
        static readonly KEY_STROKE_CONTROL: Internal.SunHints$Key;
        static readonly VALUE_DITHER_DISABLE: Internal.SunHints$Value;
        static readonly VALUE_INTERPOLATION_BICUBIC: Internal.SunHints$Value;
        static readonly VALUE_COLOR_RENDER_QUALITY: Internal.SunHints$Value;
        static readonly VALUE_RESOLUTION_VARIANT_SIZE_FIT: Internal.SunHints$Value;
        static readonly VALUE_DITHER_ENABLE: Internal.SunHints$Value;
        static readonly VALUE_FRACTIONALMETRICS_DEFAULT: Internal.SunHints$Value;
        static readonly VALUE_RESOLUTION_VARIANT_BASE: Internal.SunHints$Value;
        static readonly VALUE_TEXT_ANTIALIAS_DEFAULT: Internal.SunHints$Value;
        static readonly VALUE_ALPHA_INTERPOLATION_DEFAULT: Internal.SunHints$Value;
        static readonly KEY_INTERPOLATION: Internal.SunHints$Key;
        static readonly VALUE_STROKE_DEFAULT: Internal.SunHints$Value;
        static readonly KEY_RENDERING: Internal.SunHints$Key;
        static readonly VALUE_FRACTIONALMETRICS_OFF: Internal.SunHints$Value;
        static readonly VALUE_RENDER_SPEED: Internal.SunHints$Value;
        static readonly KEY_DITHERING: Internal.SunHints$Key;
        static readonly VALUE_RENDER_QUALITY: Internal.SunHints$Value;
        static readonly VALUE_INTERPOLATION_NEAREST_NEIGHBOR: Internal.SunHints$Value;
        static readonly VALUE_TEXT_ANTIALIAS_LCD_VRGB: Internal.SunHints$Value;
        static readonly VALUE_STROKE_PURE: Internal.SunHints$Value;
        static readonly KEY_ANTIALIASING: Internal.SunHints$Key;
        static readonly VALUE_ANTIALIAS_DEFAULT: Internal.SunHints$Value;
        static readonly VALUE_TEXT_ANTIALIAS_GASP: Internal.SunHints$Value;
        static readonly VALUE_RESOLUTION_VARIANT_DPI_FIT: Internal.SunHints$Value;
        static readonly VALUE_ANTIALIAS_ON: Internal.SunHints$Value;
        static readonly KEY_TEXT_ANTIALIASING: Internal.SunHints$Key;
        static readonly VALUE_STROKE_NORMALIZE: Internal.SunHints$Value;
    }
    type RenderingHints_ = RenderingHints;
    class Point extends Internal.Point2D implements Internal.Serializable {
        constructor()
        constructor(arg0: number, arg1: number)
        constructor(arg0: Internal.Point_)
        translate(arg0: number, arg1: number): void;
        setLocation(arg0: Internal.Point_): void;
        setLocation(arg0: number, arg1: number): void;
        getLocation(): this;
        move(arg0: number, arg1: number): void;
        set location(arg0: Internal.Point_)
        get location(): Internal.Point
        x: number;
        y: number;
    }
    type Point_ = Point;
    interface Matrix2dc {
        abstract scale(arg0: Internal.Vector2dc_, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract normalizedPositiveY(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract mul(arg0: Internal.Matrix2dc_, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: Internal.Matrix3x2d_): Internal.Matrix3x2d;
        abstract getScale(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract isFinite(): boolean;
        abstract m01(): number;
        abstract getTransposedFloats(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract positiveY(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract get(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract sub(arg0: Internal.Matrix2dc_, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract transformTranspose(arg0: number, arg1: number, arg2: Internal.Vector2d_): Internal.Vector2d;
        abstract getRotation(): number;
        abstract mulComponentWise(arg0: Internal.Matrix2dc_, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract equals(arg0: Internal.Matrix2dc_, arg1: number): boolean;
        abstract m10(): number;
        abstract transform(arg0: Internal.Vector2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract transformTranspose(arg0: Internal.Vector2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract transpose(arg0: Internal.Matrix2d_): Internal.Matrix2d;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract getToAddress(arg0: number): this;
        abstract rotateLocal(arg0: number, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract getTransposed(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract invert(arg0: Internal.Matrix2d_): Internal.Matrix2d;
        abstract rotate(arg0: number, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract mulLocal(arg0: Internal.Matrix2dc_, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract add(arg0: Internal.Matrix2dc_, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract normalizedPositiveX(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract lerp(arg0: Internal.Matrix2dc_, arg1: number, arg2: Internal.Matrix2d_): Internal.Matrix2d;
        abstract get(arg0: number[], arg1: number): number[];
        abstract getRow(arg0: number, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract getColumn(arg0: number, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract get(arg0: Internal.Matrix2d_): Internal.Matrix2d;
        abstract transform(arg0: number, arg1: number, arg2: Internal.Vector2d_): Internal.Vector2d;
        abstract transform(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract mul(arg0: Internal.Matrix2fc_, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract m00(): number;
        abstract positiveX(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract scaleLocal(arg0: number, arg1: number, arg2: Internal.Matrix2d_): Internal.Matrix2d;
        abstract get(arg0: number[]): number[];
        abstract normal(arg0: Internal.Matrix2d_): Internal.Matrix2d;
        abstract getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract determinant(): number;
        abstract scale(arg0: number, arg1: number, arg2: Internal.Matrix2d_): Internal.Matrix2d;
        abstract scale(arg0: number, arg1: Internal.Matrix2d_): Internal.Matrix2d;
        abstract getFloats(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract get(arg0: number, arg1: number): number;
        abstract getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract transformTranspose(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract getTransposedFloats(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract getFloats(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getTransposed(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract m11(): number;
        get finite(): boolean
        get rotation(): number
    }
    type Matrix2dc_ = Matrix2dc;
    class BlockAmethystDirectional extends Internal.DirectionalBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BlockAmethystDirectional_ = BlockAmethystDirectional;
    interface ICarriageBufferDistanceTracker {
        abstract railways$setTrailingDistance(arg0: number): void;
        abstract railways$setLeadingDistance(arg0: number): void;
        abstract railways$getLeadingDistance(): number;
        abstract railways$getTrailingDistance(): number;
    }
    type ICarriageBufferDistanceTracker_ = ICarriageBufferDistanceTracker;
    class ReplaceBlockConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.BlockState_, $$1: Internal.BlockState_)
        constructor($$0: Internal.List_<Internal.OreConfiguration$TargetBlockState>)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.ReplaceBlockConfiguration>;
        readonly targetStates: Internal.List<Internal.OreConfiguration$TargetBlockState>;
    }
    type ReplaceBlockConfiguration_ = ReplaceBlockConfiguration;
    class BufferBuilder$DrawState extends Internal.Record {
        constructor($$0: Internal.VertexFormat_, $$1: number, $$2: number, $$3: Internal.VertexFormat$Mode_, $$4: Internal.VertexFormat$IndexType_, $$5: boolean, $$6: boolean)
        mode(): Internal.VertexFormat$Mode;
        vertexBufferEnd(): number;
        indexOnly(): boolean;
        indexBufferStart(): number;
        vertexBufferStart(): number;
        indexBufferEnd(): number;
        vertexCount(): number;
        sequentialIndex(): boolean;
        format(): Internal.VertexFormat;
        indexCount(): number;
        indexType(): Internal.VertexFormat$IndexType;
        vertexBufferSize(): number;
        bufferSize(): number;
    }
    type BufferBuilder$DrawState_ = BufferBuilder$DrawState;
    class RingBellEffect implements Internal.PrestidigitationEffect {
        constructor()
        effectEntity(env: Internal.CastingEnvironment_, entity: Internal.Entity_): void;
        effectBlock(env: Internal.CastingEnvironment_, position: BlockPos_): void;
    }
    type RingBellEffect_ = RingBellEffect;
    class AddSpawnProperties {
        constructor()
        setEntity(s: string): void;
        setCategory(s: string): void;
        set entity(s: string)
        set category(s: string)
        minCount: number;
        _category: Internal.MobCategory;
        _entity: Internal.EntityType<any>;
        biomes: Internal.BiomeFilter;
        maxCount: number;
        weight: number;
    }
    type AddSpawnProperties_ = AddSpawnProperties;
    class AttachedStemBlock extends Internal.BushBlock {
        constructor($$0: Internal.StemGrownBlock_, $$1: Internal.Supplier_<Internal.Item>, $$2: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type AttachedStemBlock_ = AttachedStemBlock;
    class SlimeType extends Internal.Enum<Internal.SlimeType> implements Internal.StringRepresentable {
        getDefaultFoliageColor(): number;
        isNether(): boolean;
        getGrassBlockTag(): Internal.TagKey<Internal.Block>;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getDirtBlockTag(): Internal.TagKey<Internal.Block>;
        getSerializedName(): string;
        getLightLevel(): number;
        getSlimeballTag(): Internal.TagKey<Internal.Item>;
        static valueOf(name: string): Internal.SlimeType;
        getColor(): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static values(): Internal.SlimeType[];
        getHarvestTier(): Internal.Tiers;
        getMapColor(): Internal.MapColor;
        get defaultFoliageColor(): number
        get nether(): boolean
        get grassBlockTag(): Internal.TagKey<Internal.Block>
        get dirtBlockTag(): Internal.TagKey<Internal.Block>
        get serializedName(): string
        get lightLevel(): number
        get slimeballTag(): Internal.TagKey<Internal.Item>
        get color(): number
        get harvestTier(): Internal.Tiers
        get mapColor(): Internal.MapColor
        static readonly TINKER: Internal.SlimeType[];
        static readonly BLOOD: Internal.SlimeType;
        static readonly ENDER: Internal.SlimeType;
        static readonly EARTH: Internal.SlimeType;
        static readonly OVERWORLD: Internal.SlimeType[];
        static readonly NETHER: Internal.SlimeType[];
        static readonly LIQUID: Internal.SlimeType[];
        static readonly ICHOR: Internal.SlimeType;
        static readonly SKY: Internal.SlimeType;
        static readonly TRUE_SLIME: Internal.SlimeType[];
    }
    type SlimeType_ = "earth" | SlimeType | "sky" | "ender" | "ichor" | "blood";
    class Operator$Companion {
        constructor($constructor_marker: any_)
        downcast<T extends Internal.Iota>(iota: Internal.Iota_, iotaType: Internal.IotaType_<T>): T;
    }
    type Operator$Companion_ = Operator$Companion;
    class UpgradeSlotChangeResult {
        getErrorMessage(): Internal.Optional<net.minecraft.network.chat.Component>;
        getErrorInventorySlots(): Internal.Set<number>;
        getErrorInventoryParts(): Internal.Set<number>;
        isSuccessful(): boolean;
        getErrorUpgradeSlots(): Internal.Set<number>;
        get errorMessage(): Internal.Optional<net.minecraft.network.chat.Component>
        get errorInventorySlots(): Internal.Set<number>
        get errorInventoryParts(): Internal.Set<number>
        get successful(): boolean
        get errorUpgradeSlots(): Internal.Set<number>
    }
    type UpgradeSlotChangeResult_ = UpgradeSlotChangeResult;
    class FluidPipeBlock extends Internal.PipeBlock implements Internal.SimpleWaterloggedBlock, Internal.IBE<Internal.FluidPipeBlockEntity>, Internal.EncasableBlock, Internal.IWrenchableWithBracket, Internal.TransformableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static shouldDrawCasing(world: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        tryRemoveBracket(context: Internal.UseOnContext_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        playEncaseSound(level: Internal.Level_, pos: BlockPos_): void;
        tryEncase(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, heldItem: Internal.ItemStack_, player: Internal.Player_, hand: Internal.InteractionHand_, ray: Internal.BlockHitResult_): Internal.InteractionResult;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        transform(state: Internal.BlockState_, transform: Internal.StructureTransform_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FluidPipeBlockEntity;
        getBlockEntityType(): Internal.BlockEntityType<Internal.FluidPipeBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getBlockEntityClass(): typeof Internal.FluidPipeBlockEntity;
        static isOpenAt(state: Internal.BlockState_, direction: Internal.Direction_): boolean;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FluidPipeBlockEntity>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        updateBlockState(state: Internal.BlockState_, preferredDirection: Internal.Direction_, ignore: Internal.Direction_, world: Internal.BlockAndTintGetter_, pos: BlockPos_): Internal.BlockState;
        static canConnectTo(world: Internal.BlockAndTintGetter_, neighbourPos: BlockPos_, neighbour: Internal.BlockState_, direction: Internal.Direction_): boolean;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static shouldDrawRim(world: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.BlockState_, direction: Internal.Direction_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static isCornerOrEndPipe(world: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        removeBracket(world: Internal.BlockGetter_, pos: BlockPos_, inOnReplacedContext: boolean): Internal.Optional<Internal.ItemStack>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FluidPipeBlockEntity>): void;
        static isPipe(state: Internal.BlockState_): boolean;
        emi(amount: number): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FluidPipeBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getAxisState(axis: Internal.Direction$Axis_): Internal.BlockState;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockEntityType(): Internal.BlockEntityType<Internal.FluidPipeBlockEntity>
        set lightEmission(v: number)
        get blockEntityClass(): typeof Internal.FluidPipeBlockEntity
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type FluidPipeBlock_ = FluidPipeBlock;
    interface IColorableBlockEntity {
        abstract getColor(): Internal.AEColor;
        abstract recolourBlock(arg0: Internal.Direction_, arg1: Internal.AEColor_, arg2: Internal.Player_): boolean;
        get color(): Internal.AEColor
    }
    type IColorableBlockEntity_ = IColorableBlockEntity;
    interface DensityFunctions$MarkerOrMarked extends Internal.DensityFunction {
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        abstract maxValue(): number;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        abstract compute(arg0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        square(): Internal.DensityFunction;
        mapAll($$0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        abstract wrapped(): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        abstract type(): Internal.DensityFunctions$Marker$Type;
        cube(): Internal.DensityFunction;
        abstract fillArray(arg0: number[], arg1: Internal.DensityFunction$ContextProvider_): void;
        abstract minValue(): number;
    }
    type DensityFunctions$MarkerOrMarked_ = DensityFunctions$MarkerOrMarked;
    interface EntityBlock {
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        abstract newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        (arg0: BlockPos, arg1: Internal.BlockState): Internal.BlockEntity_;
    }
    type EntityBlock_ = EntityBlock;
    class ButtonBlockBuilder extends Internal.ShapedBlockBuilder {
        constructor(i: ResourceLocation_)
        behaviour(wt: string): this;
        arrowsCanPress(b: boolean): this;
        ticksToStayPressed(t: number): this;
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        behaviour(wt: Internal.BlockSetType_): this;
        createObject(): Internal.Block;
    }
    type ButtonBlockBuilder_ = ButtonBlockBuilder;
    class GiantGlowshroomFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type GiantGlowshroomFeature_ = GiantGlowshroomFeature;
    class BiasedToBottomHeight extends Internal.HeightProvider {
        static of($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_, $$2: number): Internal.BiasedToBottomHeight;
        static readonly CODEC: Internal.Codec<Internal.BiasedToBottomHeight>;
    }
    type BiasedToBottomHeight_ = BiasedToBottomHeight;
    interface ParticleProvider <T extends Internal.ParticleOptions> {
        abstract createParticle(arg0: T, arg1: Internal.ClientLevel_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Particle;
        (arg0: T, arg1: Internal.ClientLevel, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Particle_;
    }
    type ParticleProvider_<T extends Internal.ParticleOptions> = ParticleProvider<T>;
    class StringArgumentSerializer$Template implements Internal.ArgumentTypeInfo$Template<Internal.StringArgumentType> {
        constructor($$0: Internal.StringArgumentSerializer_, $$1: Internal.StringArgumentType$StringType_)
        instantiate(arg0: Internal.CommandBuildContext_): Internal.ArgumentType<any>;
        type(): Internal.ArgumentTypeInfo<Internal.StringArgumentType, any>;
        instantiate($$0: Internal.CommandBuildContext_): Internal.StringArgumentType;
    }
    type StringArgumentSerializer$Template_ = StringArgumentSerializer$Template;
    class SeedBagItem$BagEntry extends Internal.Record {
        constructor(count: number, genome: Internal.AgriGenome_)
        count(): number;
        static fromNBT(tag: Internal.CompoundTag_): Internal.SeedBagItem$BagEntry;
        writeToNBT(tag: Internal.CompoundTag_): void;
        genome(): Internal.AgriGenome;
    }
    type SeedBagItem$BagEntry_ = SeedBagItem$BagEntry;
    abstract class Writer implements Internal.Closeable, Internal.Appendable, Internal.Flushable {
        abstract flush(): void;
        write(arg0: number): void;
        append(arg0: Internal.CharSequence_, arg1: number, arg2: number): this;
        write(arg0: string): void;
        abstract close(): void;
        write(arg0: string, arg1: number, arg2: number): void;
        write(arg0: string[]): void;
        append(arg0: Internal.CharSequence_): this;
        abstract write(arg0: string[], arg1: number, arg2: number): void;
        append(arg0: string): this;
        static nullWriter(): Internal.Writer;
    }
    type Writer_ = Writer;
    interface CustomDataPacketHandlingBlockEntity {
        abstract onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        (arg0: Internal.Connection, arg1: Internal.ClientboundBlockEntityDataPacket): void;
    }
    type CustomDataPacketHandlingBlockEntity_ = CustomDataPacketHandlingBlockEntity;
    interface BlockStateBlockItemGroup$GroupedBlock {
    }
    type BlockStateBlockItemGroup$GroupedBlock_ = BlockStateBlockItemGroup$GroupedBlock;
    class BoatItemBOP extends Internal.Item {
        constructor(hasChest: boolean, type: any_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BoatItemBOP_ = BoatItemBOP;
    class MobSpawnSettings$MobSpawnCost extends Internal.Record {
        constructor($$0: number, $$1: number)
        charge(): number;
        energyBudget(): number;
        static readonly CODEC: Internal.Codec<Internal.MobSpawnSettings$MobSpawnCost>;
    }
    type MobSpawnSettings$MobSpawnCost_ = MobSpawnSettings$MobSpawnCost;
    /**
     * Invoked before an entity is hurt by a damage source.
    */
    class LivingEntityHurtEventJS extends Internal.LivingEntityEventJS {
        constructor(entity: Internal.LivingEntity_, source: DamageSource_, amount: number)
        /**
         * The damage source.
        */
        getSource(): DamageSource;
        /**
         * The amount of damage.
        */
        getDamage(): number;
        /**
         * The damage source.
        */
        get source(): DamageSource
        /**
         * The amount of damage.
        */
        get damage(): number
    }
    type LivingEntityHurtEventJS_ = LivingEntityHurtEventJS;
    interface Tag {
        getAsString(): string;
        abstract getType(): Internal.TagType<any>;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        abstract toString(): string;
        abstract copy(): this;
        abstract write(arg0: Internal.DataOutput_): void;
        abstract getId(): number;
        abstract accept(arg0: Internal.StreamTagVisitor_): Internal.StreamTagVisitor$ValueResult;
        abstract accept(arg0: Internal.TagVisitor_): void;
        abstract sizeInBytes(): number;
        get asString(): string
        get type(): Internal.TagType<any>
        get id(): number
        readonly OBJECT_REFERENCE: 4;
        readonly TAG_FLOAT: 5;
        readonly TAG_BYTE_ARRAY: 7;
        readonly OBJECT_HEADER: 8;
        readonly TAG_BYTE: 1;
        readonly TAG_INT_ARRAY: 11;
        readonly TAG_LONG_ARRAY: 12;
        readonly TAG_ANY_NUMERIC: 99;
        readonly MAX_DEPTH: 512;
        readonly TAG_LIST: 9;
        readonly STRING_SIZE: 28;
        readonly TAG_INT: 3;
        readonly TAG_SHORT: 2;
        readonly TAG_COMPOUND: 10;
        readonly TAG_STRING: 8;
        readonly TAG_END: 0;
        readonly ARRAY_HEADER: 12;
        readonly TAG_LONG: 4;
        readonly TAG_DOUBLE: 6;
    }
    type Tag_ = Tag;
    interface TurtleUpgradeSerialiser <T extends Internal.ITurtleUpgrade> extends Internal.UpgradeSerialiser<T> {
        abstract fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): T;
        simpleWithCustomItem<T extends Internal.ITurtleUpgrade>(factory: Internal.BiFunction_<ResourceLocation, Internal.ItemStack, T>): this;
        abstract fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): T;
        simple<T extends Internal.ITurtleUpgrade>(factory: Internal.Function_<ResourceLocation, T>): this;
        abstract toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
        registryId(): Internal.ResourceKey<Internal.Registry<Internal.TurtleUpgradeSerialiser<any>>>;
    }
    type TurtleUpgradeSerialiser_<T extends Internal.ITurtleUpgrade> = TurtleUpgradeSerialiser<T> | Special.TurtleUpgradeSerialiser;
    class IglooStructure extends Internal.Structure {
        constructor($$0: Internal.Structure$StructureSettings_)
        method_38676($$0: Internal.Structure$GenerationContext_): Internal.Optional<Internal.Structure$GenerationStub>;
        static readonly CODEC: Internal.Codec<Internal.IglooStructure>;
    }
    type IglooStructure_ = IglooStructure;
    class TimeArgument$Info implements Internal.ArgumentTypeInfo<Internal.TimeArgument, Internal.TimeArgument$Info$Template> {
        constructor()
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        serializeToJson($$0: Internal.TimeArgument$Info$Template_, $$1: Internal.JsonObject_): void;
        deserializeFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.TimeArgument$Info$Template;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
        serializeToNetwork($$0: Internal.TimeArgument$Info$Template_, $$1: Internal.FriendlyByteBuf_): void;
        unpack($$0: Internal.TimeArgument_): Internal.TimeArgument$Info$Template;
    }
    type TimeArgument$Info_ = TimeArgument$Info;
    class Spider extends Internal.Monster {
        constructor($$0: Internal.EntityType_<Internal.Spider>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        isClimbing(): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setClimbing($$0: boolean): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get climbing(): boolean
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set climbing($$0: boolean)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Spider_ = Spider;
    class TagLoader$EntryWithSource extends Internal.Record {
        constructor($$0: Internal.TagEntry_, $$1: string)
        source(): string;
        entry(): Internal.TagEntry;
    }
    type TagLoader$EntryWithSource_ = TagLoader$EntryWithSource;
    abstract class IdScriptableObject extends Internal.ScriptableObject implements Internal.IdFunctionCall {
        constructor()
        constructor(scope: Internal.Scriptable_, prototype: Internal.Scriptable_)
        enumerationIteratorNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        initPrototypeValue(id: number, key: Internal.Symbol_, value: any, attributes: number): void;
        initPrototypeConstructor(f: Internal.IdFunctionObject_, cx: Internal.Context_): void;
        hasPrototypeMap(): boolean;
        initPrototypeValue(id: number, name: string, value: any, attributes: number): void;
        initPrototypeMethod(tag: any, id: number, name: string, arity: number, cx: Internal.Context_): Internal.IdFunctionObject;
        initPrototypeMethod(tag: any, id: number, key: Internal.Symbol_, functionName: string, arity: number, cx: Internal.Context_): Internal.IdFunctionObject;
        execIdCall(f: Internal.IdFunctionObject_, cx: Internal.Context_, scope: Internal.Scriptable_, thisObj: Internal.Scriptable_, args: any[]): any;
        enumerationIteratorHasNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        initPrototypeMethod(tag: any, id: number, propertyName: string, functionName: string, arity: number, cx: Internal.Context_): Internal.IdFunctionObject;
        activatePrototypeMap(maxPrototypeId: number): void;
        exportAsJSClass(maxPrototypeId: number, scope: Internal.Scriptable_, sealed: boolean, cx: Internal.Context_): Internal.IdFunctionObject;
    }
    type IdScriptableObject_ = IdScriptableObject;
    class NameTagItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type NameTagItem_ = NameTagItem;
    abstract class Structure {
        static simpleCodec<S extends Internal.Structure>($$0: Internal.Function_<Internal.Structure$StructureSettings, S>): Internal.Codec<S>;
        abstract type(): Internal.StructureType<any>;
        generate($$0: Internal.RegistryAccess_, $$1: Internal.ChunkGenerator_, $$2: Internal.BiomeSource_, $$3: Internal.RandomState_, $$4: Internal.StructureTemplateManager_, $$5: number, $$6: Internal.ChunkPos_, $$7: number, $$8: Internal.LevelHeightAccessor_, $$9: Internal.Predicate_<Internal.Holder<Internal.Biome>>): Internal.StructureStart;
        static settingsCodec<S extends Internal.Structure>($$0: Internal.RecordCodecBuilder$Instance_<S>): Internal.RecordCodecBuilder<S, Internal.Structure$StructureSettings>;
        biomes(): Internal.HolderSet<Internal.Biome>;
        findValidGenerationPoint($$0: Internal.Structure$GenerationContext_): Internal.Optional<Internal.Structure$GenerationStub>;
        spawnOverrides(): Internal.Map<Internal.MobCategory, Internal.StructureSpawnOverride>;
        step(): Internal.GenerationStep$Decoration;
        afterPlace($$0: Internal.WorldGenLevel_, $$1: Internal.StructureManager_, $$2: Internal.ChunkGenerator_, $$3: Internal.RandomSource_, $$4: Internal.BoundingBox_, $$5: Internal.ChunkPos_, $$6: Internal.PiecesContainer_): void;
        terrainAdaptation(): Internal.TerrainAdjustment;
        adjustBoundingBox($$0: Internal.BoundingBox_): Internal.BoundingBox;
        set tingsCodec($$0: Internal.RecordCodecBuilder$Instance_<S>)
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.Structure>>;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.Structure>;
    }
    type Structure_ = Special.Structure | Structure;
    abstract class ImmutableCollections$AbstractImmutableList <E> extends Internal.ImmutableCollections$AbstractImmutableCollection<E> implements Internal.RandomAccess, Internal.List<E> {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        addLast(arg0: E): void;
        abstract get(arg0: number): E;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        getLast(): E;
        listIterator(): Internal.ListIterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        sort(arg0: Internal.Comparator_<E>): void;
        set(arg0: number, arg1: E): E;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        remove(arg0: number): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        subList(arg0: number, arg1: number): Internal.List<E>;
        abstract indexOf(arg0: any): number;
        addFirst(arg0: E): void;
        add(arg0: number, arg1: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        abstract toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        listIterator(arg0: number): Internal.ListIterator<E>;
        getFirst(): E;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        spliterator(): Internal.Spliterator<E>;
        removeLast(): E;
        abstract lastIndexOf(arg0: any): number;
        get last(): E
        get first(): E
    }
    type ImmutableCollections$AbstractImmutableList_<E> = ImmutableCollections$AbstractImmutableList<E>;
    class BrambleLeavesBlock extends Internal.DirectionalBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BrambleLeavesBlock_ = BrambleLeavesBlock;
    interface Matrix2fc {
        abstract rotate(arg0: number, arg1: Internal.Matrix2f_): Internal.Matrix2f;
        abstract m00(): number;
        abstract invert(arg0: Internal.Matrix2f_): Internal.Matrix2f;
        abstract normalizedPositiveX(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract scale(arg0: Internal.Vector2fc_, arg1: Internal.Matrix2f_): Internal.Matrix2f;
        abstract get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract getRow(arg0: number, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract getColumn(arg0: number, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract lerp(arg0: Internal.Matrix2fc_, arg1: number, arg2: Internal.Matrix2f_): Internal.Matrix2f;
        abstract get(arg0: Internal.Matrix2f_): Internal.Matrix2f;
        abstract isFinite(): boolean;
        abstract transform(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract mul(arg0: Internal.Matrix2fc_, arg1: Internal.Matrix2f_): Internal.Matrix2f;
        abstract positiveX(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract normal(arg0: Internal.Matrix2f_): Internal.Matrix2f;
        abstract m10(): number;
        abstract scaleLocal(arg0: number, arg1: number, arg2: Internal.Matrix2f_): Internal.Matrix2f;
        abstract sub(arg0: Internal.Matrix2fc_, arg1: Internal.Matrix2f_): Internal.Matrix2f;
        abstract get(arg0: number[]): number[];
        abstract transformTranspose(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract mulComponentWise(arg0: Internal.Matrix2fc_, arg1: Internal.Matrix2f_): Internal.Matrix2f;
        abstract get(arg0: Matrix3f_): Matrix3f;
        abstract get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract get(arg0: number[], arg1: number): number[];
        abstract get(arg0: number, arg1: number): number;
        abstract transform(arg0: Internal.Vector2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract transformTranspose(arg0: Internal.Vector2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract determinant(): number;
        abstract mulLocal(arg0: Internal.Matrix2fc_, arg1: Internal.Matrix2f_): Internal.Matrix2f;
        abstract m01(): number;
        abstract add(arg0: Internal.Matrix2fc_, arg1: Internal.Matrix2f_): Internal.Matrix2f;
        abstract normalizedPositiveY(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract rotateLocal(arg0: number, arg1: Internal.Matrix2f_): Internal.Matrix2f;
        abstract getRotation(): number;
        abstract get(arg0: Internal.Matrix3x2f_): Internal.Matrix3x2f;
        abstract getScale(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract scale(arg0: number, arg1: number, arg2: Internal.Matrix2f_): Internal.Matrix2f;
        abstract getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract positiveY(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract scale(arg0: number, arg1: Internal.Matrix2f_): Internal.Matrix2f;
        abstract m11(): number;
        abstract getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract equals(arg0: Internal.Matrix2fc_, arg1: number): boolean;
        abstract transform(arg0: number, arg1: number, arg2: Internal.Vector2f_): Internal.Vector2f;
        abstract getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract getToAddress(arg0: number): this;
        abstract transpose(arg0: Internal.Matrix2f_): Internal.Matrix2f;
        abstract transformTranspose(arg0: number, arg1: number, arg2: Internal.Vector2f_): Internal.Vector2f;
        get finite(): boolean
        get rotation(): number
    }
    type Matrix2fc_ = Matrix2fc;
    class Rabbit$Variant extends Internal.Enum<Internal.Rabbit$Variant> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static byId($$0: number): Internal.Rabbit$Variant;
        id(): number;
        static values(): Internal.Rabbit$Variant[];
        getSerializedName(): string;
        static valueOf($$0: string): Internal.Rabbit$Variant;
        get serializedName(): string
        static readonly WHITE_SPLOTCHED: Internal.Rabbit$Variant;
        static readonly EVIL: Internal.Rabbit$Variant;
        static readonly WHITE: Internal.Rabbit$Variant;
        static readonly SALT: Internal.Rabbit$Variant;
        static readonly BLACK: Internal.Rabbit$Variant;
        static readonly GOLD: Internal.Rabbit$Variant;
        static readonly BROWN: Internal.Rabbit$Variant;
        static readonly CODEC: Internal.Codec<Internal.Rabbit$Variant>;
    }
    type Rabbit$Variant_ = "white_splotched" | Rabbit$Variant | "gold" | "white" | "evil" | "brown" | "black" | "salt";
    interface JsonSerializationContext {
        abstract serialize(arg0: any): Internal.JsonElement;
        abstract serialize(arg0: any, arg1: Internal.Type_): Internal.JsonElement;
    }
    type JsonSerializationContext_ = JsonSerializationContext;
    class DragonColor extends Internal.Record {
        constructor(name: string, color: Internal.ChatFormatting_, dragonType: Internal.DragonType_, eggItem: Internal.Supplier_<Internal.Item>, scaleItem: Internal.Supplier_<Internal.Item>)
        getEggTexture(): ResourceLocation;
        getScaleItem(): Internal.Item;
        eggItem(): Internal.Supplier<Internal.Item>;
        static getById(id: string): Internal.DragonColor;
        dragonType(): Internal.DragonType;
        getBodyTexture(stage: number): ResourceLocation;
        getEggItem(): Internal.Item;
        getSkeletonTexture(stage: number): ResourceLocation;
        getEyesTexture(stage: number): ResourceLocation;
        name(): string;
        getTextureByEntity(dragon: Internal.EntityDragonBase_): ResourceLocation;
        scaleItem(): Internal.Supplier<Internal.Item>;
        getSleepTexture(stage: number): ResourceLocation;
        static getColorsByType(type: Internal.DragonType_): Internal.List<Internal.DragonColor>;
        getMaleOverlay(): ResourceLocation;
        static values(): Internal.List<Internal.DragonColor>;
        color(): Internal.ChatFormatting;
        get eggTexture(): ResourceLocation
        get scaleItem(): Internal.Item
        get eggItem(): Internal.Item
        get maleOverlay(): ResourceLocation
        static readonly COPPER: Internal.DragonColor;
        static readonly GRAY: Internal.DragonColor;
        static readonly BLUE: Internal.DragonColor;
        static readonly BRONZE: Internal.DragonColor;
        static readonly SAPPHIRE: Internal.DragonColor;
        static readonly AMETHYST: Internal.DragonColor;
        static readonly BLACK: Internal.DragonColor;
        static readonly GREEN: Internal.DragonColor;
        static readonly SILVER: Internal.DragonColor;
        static readonly ELECTRIC: Internal.DragonColor;
        static readonly RED: Internal.DragonColor;
        static readonly WHITE: Internal.DragonColor;
    }
    type DragonColor_ = DragonColor;
    class EventFactory$EventImpl <T> implements dev.architectury.event.Event<T> {
        constructor(function_: Internal.Function_<Internal.List<T>, T>)
        invoker(): T;
        unregister(listener: T): void;
        update(): void;
        register(listener: T): void;
        isRegistered(listener: T): boolean;
        clearListeners(): void;
    }
    type EventFactory$EventImpl_<T> = EventFactory$EventImpl<T>;
    class Vindicator extends Internal.AbstractIllager {
        constructor($$0: Internal.EntityType_<Internal.Vindicator>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        handler$bai000$arsenal$equipScytheOnRaidVindicators(wave: number, unused: boolean, ci: Internal.CallbackInfo_): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Vindicator_ = Vindicator;
    class TrackMaterial {
        constructor(id: ResourceLocation_, langName: string, trackBlock: Internal.NonNullSupplier_<Internal.NonNullSupplier<Internal.TrackBlock>>, particle: ResourceLocation_, sleeperIngredient: Internal.Ingredient_, railsIngredient: Internal.Ingredient_, trackType: Internal.TrackMaterial$TrackType_, modelHolder: Internal.Supplier_<Internal.Supplier<Internal.TrackMaterial$TrackModelHolder>>, customFactory: any_)
        constructor(id: ResourceLocation_, langName: string, trackBlock: Internal.NonNullSupplier_<Internal.NonNullSupplier<Internal.TrackBlock>>, particle: ResourceLocation_, sleeperIngredient: Internal.Ingredient_, railsIngredient: Internal.Ingredient_, trackType: Internal.TrackMaterial$TrackType_, modelHolder: Internal.Supplier_<Internal.Supplier<Internal.TrackMaterial$TrackModelHolder>>)
        isFromMod(modId: string): boolean;
        static fromItem(item: Internal.Item_): Internal.TrackMaterial;
        static deserialize(serializedName: string): Internal.TrackMaterial;
        asStack(count: number): Internal.ItemStack;
        getBlock(): Internal.TrackBlock;
        static allFromMod(modid: string): Internal.List<Internal.TrackMaterial>;
        createBlock(properties: Internal.BlockBehaviour$Properties_): Internal.TrackBlock;
        getBlockSupplier(): Internal.NonNullSupplier<Internal.TrackBlock>;
        static allBlocks(): Internal.List<Internal.NonNullSupplier<Internal.Block>>;
        getModelHolder(): Internal.TrackMaterial$TrackModelHolder;
        static allBlocksFromMod(modid: string): Internal.List<Internal.NonNullSupplier<Internal.Block>>;
        resourceName(): string;
        asStack(): Internal.ItemStack;
        get block(): Internal.TrackBlock
        get blockSupplier(): Internal.NonNullSupplier<Internal.TrackBlock>
        get modelHolder(): Internal.TrackMaterial$TrackModelHolder
        readonly sleeperIngredient: Internal.Ingredient;
        readonly langName: string;
        readonly railsIngredient: Internal.Ingredient;
        readonly particle: ResourceLocation;
        static readonly ALL: {[key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial, [key: ResourceLocation]: Internal.TrackMaterial};
        readonly trackType: Internal.TrackMaterial$TrackType;
        readonly trackBlock: Internal.NonNullSupplier<Internal.NonNullSupplier<Internal.TrackBlock>>;
        readonly id: ResourceLocation;
        static readonly ANDESITE: Internal.TrackMaterial;
    }
    type TrackMaterial_ = TrackMaterial;
    class GlowwormSilkBlock extends Internal.HangingStrandBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type GlowwormSilkBlock_ = GlowwormSilkBlock;
    class ReportingContext {
        constructor($$0: Internal.AbuseReportSender_, $$1: Internal.ReportEnvironment_, $$2: Internal.ChatLog_)
        matches($$0: Internal.ReportEnvironment_): boolean;
        static create($$0: Internal.ReportEnvironment_, $$1: Internal.UserApiService_): Internal.ReportingContext;
        draftReportHandled($$0: Internal.Minecraft_, $$1: Internal.Screen_, $$2: Internal.Runnable_, $$3: boolean): void;
        setChatReportDraft($$0: Internal.ChatReportBuilder$ChatReport_): void;
        sender(): Internal.AbuseReportSender;
        hasDraftReport(): boolean;
        chatLog(): Internal.ChatLog;
        hasDraftReportFor($$0: Internal.UUID_): boolean;
        set chatReportDraft($$0: Internal.ChatReportBuilder$ChatReport_)
    }
    type ReportingContext_ = ReportingContext;
    interface Long2BooleanFunction extends it.unimi.dsi.fastutil.Function<number, boolean>, Internal.LongPredicate {
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2BooleanFunction<T>;
        remove(arg0: number): boolean;
        put(arg0: number, arg1: boolean): boolean;
        test(arg0: number): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2BooleanFunction;
        andThenLong(arg0: Internal.Boolean2LongFunction_): Internal.Long2LongFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2BooleanFunction;
        andThenChar(arg0: Internal.Boolean2CharFunction_): Internal.Long2CharFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, boolean>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<boolean, T>): Internal.Function<number, T>;
        or(arg0: Internal.LongPredicate_): Internal.LongPredicate;
        /**
         * @deprecated
        */
        get(arg0: any): boolean;
        apply(arg0: number): boolean;
        andThenFloat(arg0: Internal.Boolean2FloatFunction_): Internal.Long2FloatFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        abstract get(arg0: number): boolean;
        andThenByte(arg0: Internal.Boolean2ByteFunction_): Internal.Long2ByteFunction;
        and(arg0: Internal.LongPredicate_): Internal.LongPredicate;
        defaultReturnValue(): boolean;
        negate(): Internal.LongPredicate;
        composeLong(arg0: Internal.Long2LongFunction_): this;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: boolean): boolean;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2BooleanFunction;
        containsKey(arg0: number): boolean;
        getOrDefault(arg0: number, arg1: boolean): boolean;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2BooleanFunction;
        andThenReference<T>(arg0: Internal.Boolean2ReferenceFunction_<T>): Internal.Long2ReferenceFunction<T>;
        andThenShort(arg0: Internal.Boolean2ShortFunction_): Internal.Long2ShortFunction;
        andThenDouble(arg0: Internal.Boolean2DoubleFunction_): Internal.Long2DoubleFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: boolean): boolean;
        andThenInt(arg0: Internal.Boolean2IntFunction_): Internal.Long2IntFunction;
        size(): number;
        andThenObject<T>(arg0: Internal.Boolean2ObjectFunction_<T>): Internal.Long2ObjectFunction<T>;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2BooleanFunction<T>;
        clear(): void;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2BooleanFunction;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: boolean): void;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2BooleanFunction;
        (arg0: number): boolean;
    }
    type Long2BooleanFunction_ = Long2BooleanFunction;
    class ElectricMotorBlock extends Internal.DirectionalKineticBlock implements Internal.ConnectableRedstoneBlock, Internal.IBE<Internal.ElectricMotorBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ElectricMotorBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        canConnectRedstone(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ElectricMotorBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        setPowered(world: Internal.Level_, pos: BlockPos_, powered: boolean): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityClass(): typeof Internal.ElectricMotorBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ElectricMotorBlockEntity>): void;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ElectricMotorBlockEntity;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ElectricMotorBlockEntity>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.ElectricMotorBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.ElectricMotorBlockEntity
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly ELECTRIC_MOTOR_SHAPE: Internal.VoxelShaper;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type ElectricMotorBlock_ = ElectricMotorBlock;
    abstract class OperatorBasic extends Internal.Operator {
        constructor(arity: number, accepts: Internal.IotaMultiPredicate_)
        abstract apply(arg0: Internal.Iterable_<Internal.Iota>, arg1: Internal.CastingEnvironment_): Internal.Iterable<Internal.Iota>;
    }
    type OperatorBasic_ = OperatorBasic;
    class AdvancedCopperFluidPipeBlock extends Internal.CopperFluidPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type AdvancedCopperFluidPipeBlock_ = AdvancedCopperFluidPipeBlock;
    interface OptionalSupplier <T> extends Internal.Supplier<T> {
        getOrNull(): T;
        orElse(other: T): T;
        abstract isPresent(): boolean;
        stream(): Internal.Stream<T>;
        ifPresent(action: Internal.Consumer_<T>): void;
        orElseGet(supplier: Internal.Supplier_<T>): T;
        ifPresentOrElse(action: Internal.Consumer_<T>, emptyAction: Internal.Runnable_): void;
        abstract get(): T;
        toOptional(): Internal.Optional<T>;
        get orNull(): T
        get present(): boolean
    }
    type OptionalSupplier_<T> = OptionalSupplier<T>;
    class BlockLectern extends Internal.BaseEntityBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(world: Internal.Level_, state: Internal.BlockState_, entityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type BlockLectern_ = BlockLectern;
}
declare namespace me.pepperbell.simplenetworking {
    interface Packet {
        abstract encode(arg0: Internal.FriendlyByteBuf_): void;
        (arg0: Internal.FriendlyByteBuf): void;
    }
    type Packet_ = Packet;
}
declare namespace net.minecraft.world {
    interface ContainerListener {
        abstract containerChanged(arg0: net.minecraft.world.Container_): void;
        (arg0: net.minecraft.world.Container): void;
    }
    type ContainerListener_ = ContainerListener;
}
declare namespace com.simibubi.create.content.kinetics.drill {
    class DrillBlock extends Internal.DirectionalKineticBlock implements Internal.IBE<Internal.DrillBlockEntity>, Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.DrillBlockEntity;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static getDamage(speed: number): number;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.DrillBlockEntity>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.DrillBlockEntity>): void;
        getBlockEntityClass(): typeof Internal.DrillBlockEntity;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.DrillBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.DrillBlockEntity>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.DrillBlockEntity>
        get blockEntityClass(): typeof Internal.DrillBlockEntity
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type DrillBlock_ = DrillBlock;
}
